/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameterList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class ThreadWithDefaultRunMethodInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("thread.with.default.run.method.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/threading/ThreadWithDefaultRunMethodInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getID() {
        if ("InstantiatingAThreadWithDefaultRunMethod" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/threading/ThreadWithDefaultRunMethodInspection.getID must not return null");
        }
        return "InstantiatingAThreadWithDefaultRunMethod";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("thread.with.default.run.method.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/threading/ThreadWithDefaultRunMethodInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ThreadWithDefaultRunMethodVisitor();
    }

    private static class ThreadWithDefaultRunMethodVisitor
    extends BaseInspectionVisitor {
        private ThreadWithDefaultRunMethodVisitor() {
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/threading/ThreadWithDefaultRunMethodInspection$ThreadWithDefaultRunMethodVisitor.visitNewExpression must not be null");
            }
            super.visitNewExpression(expression);
            PsiAnonymousClass anonymousClass = expression.getAnonymousClass();
            if (anonymousClass != null) {
                PsiExpression[] arguments;
                PsiJavaCodeReferenceElement baseClassReference = anonymousClass.getBaseClassReference();
                PsiElement referent = baseClassReference.resolve();
                if (referent == null) {
                    return;
                }
                PsiClass referencedClass = (PsiClass)referent;
                String referencedClassName = referencedClass.getQualifiedName();
                if (!"java.lang.Thread".equals(referencedClassName)) {
                    return;
                }
                if (ThreadWithDefaultRunMethodVisitor.definesRun(anonymousClass)) {
                    return;
                }
                PsiExpressionList argumentList = expression.getArgumentList();
                if (argumentList == null) {
                    return;
                }
                for (PsiExpression argument : arguments = argumentList.getExpressions()) {
                    if (!TypeUtils.expressionHasTypeOrSubtype(argument, "java.lang.Runnable")) continue;
                    return;
                }
                this.registerNewExpressionError(expression, new Object[0]);
            } else {
                PsiExpression[] arguments;
                PsiJavaCodeReferenceElement classReference = expression.getClassReference();
                if (classReference == null) {
                    return;
                }
                PsiElement referent = classReference.resolve();
                if (referent == null) {
                    return;
                }
                PsiClass referencedClass = (PsiClass)referent;
                String referencedClassName = referencedClass.getQualifiedName();
                if (!"java.lang.Thread".equals(referencedClassName)) {
                    return;
                }
                PsiExpressionList argumentList = expression.getArgumentList();
                if (argumentList == null) {
                    return;
                }
                for (PsiExpression argument : arguments = argumentList.getExpressions()) {
                    if (!TypeUtils.expressionHasTypeOrSubtype(argument, "java.lang.Runnable")) continue;
                    return;
                }
                this.registerNewExpressionError(expression, new Object[0]);
            }
        }

        private static boolean definesRun(PsiAnonymousClass aClass) {
            PsiMethod[] methods;
            for (PsiMethod method : methods = aClass.getMethods()) {
                PsiParameterList parameterList;
                String methodName = method.getName();
                if (!"run".equals(methodName) || (parameterList = method.getParameterList()).getParametersCount() != 0) continue;
                return true;
            }
            return false;
        }
    }
}

