/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.telemetry;

import com.siyeh.ig.InspectionRunListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class InspectionGadgetsTelemetry
implements InspectionRunListener {
    private final Map<String, Integer> totalRunCount = new HashMap<String, Integer>(400);
    private final Map<String, Long> totalRunTime = new HashMap<String, Long>(400);
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportRun(String inspectionID, long runTime) {
        Object object = this.lock;
        synchronized (object) {
            Integer count = this.totalRunCount.get(inspectionID);
            if (count == null) {
                this.totalRunCount.put(inspectionID, 1);
            } else {
                this.totalRunCount.put(inspectionID, count + 1);
            }
            Long runTimeSoFar = this.totalRunTime.get(inspectionID);
            if (runTimeSoFar == null) {
                this.totalRunTime.put(inspectionID, runTime);
            } else {
                this.totalRunTime.put(inspectionID, runTimeSoFar + runTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            this.totalRunCount.clear();
            this.totalRunTime.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRunTimeForInspection(String inspectionID) {
        Object object = this.lock;
        synchronized (object) {
            Long runTime = this.totalRunTime.get(inspectionID);
            if (runTime == null) {
                return 0L;
            }
            return runTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRunCountForInspection(String inspectionID) {
        Object object = this.lock;
        synchronized (object) {
            Integer runCount = this.totalRunCount.get(inspectionID);
            if (runCount == null) {
                return 0;
            }
            return runCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getInspections() {
        Object object = this.lock;
        synchronized (object) {
            Set<String> inspections = this.totalRunCount.keySet();
            int numInspections = inspections.size();
            Object[] inspectionArray = inspections.toArray(new String[numInspections]);
            Arrays.sort(inspectionArray);
            return inspectionArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getAverageRunTimeForInspection(String inspectionID) {
        Object object = this.lock;
        synchronized (object) {
            Integer runCount = this.totalRunCount.get(inspectionID);
            if (runCount == null) {
                return 0.0;
            }
            Long runTime = this.totalRunTime.get(inspectionID);
            return (double)runTime.longValue() / (double)runCount.intValue();
        }
    }
}

