/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RemoveModifierFix;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryFinalOnLocalVariableInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.final.on.local.variable.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/UnnecessaryFinalOnLocalVariableInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiVariable parameter = (PsiVariable)infos[0];
        String parameterName = parameter.getName();
        String string = InspectionGadgetsBundle.message("unnecessary.final.on.local.variable.problem.descriptor", parameterName);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/UnnecessaryFinalOnLocalVariableInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryFinalOnLocalVariableVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new RemoveModifierFix((String)infos[1]);
    }

    private static class UnnecessaryFinalOnLocalVariableVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryFinalOnLocalVariableVisitor() {
        }

        public void visitDeclarationStatement(PsiDeclarationStatement statement) {
            super.visitDeclarationStatement(statement);
            PsiElement[] declaredElements = statement.getDeclaredElements();
            if (declaredElements.length == 0) {
                return;
            }
            for (PsiElement declaredElement : declaredElements) {
                if (!(declaredElement instanceof PsiLocalVariable)) {
                    return;
                }
                PsiLocalVariable variable = (PsiLocalVariable)declaredElement;
                if (variable.hasModifierProperty("final")) continue;
                return;
            }
            PsiCodeBlock containingBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiCodeBlock.class);
            if (containingBlock == null) {
                return;
            }
            for (PsiElement declaredElement : declaredElements) {
                PsiLocalVariable variable = (PsiLocalVariable)declaredElement;
                if (!VariableAccessUtils.variableIsUsedInInnerClass((PsiVariable)variable, (PsiElement)containingBlock)) continue;
                return;
            }
            PsiLocalVariable variable = (PsiLocalVariable)statement.getDeclaredElements()[0];
            this.registerModifierError("final", (PsiModifierListOwner)variable, variable, "final");
        }

        public void visitTryStatement(@NotNull PsiTryStatement statement) {
            PsiCatchSection[] catchSections;
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/style/UnnecessaryFinalOnLocalVariableInspection$UnnecessaryFinalOnLocalVariableVisitor.visitTryStatement must not be null");
            }
            super.visitTryStatement(statement);
            for (PsiCatchSection catchSection : catchSections = statement.getCatchSections()) {
                PsiParameter parameter = catchSection.getParameter();
                PsiCodeBlock catchBlock = catchSection.getCatchBlock();
                if (parameter == null || catchBlock == null || !parameter.hasModifierProperty("final") || VariableAccessUtils.variableIsUsedInInnerClass((PsiVariable)parameter, (PsiElement)catchBlock)) continue;
                this.registerModifierError("final", (PsiModifierListOwner)parameter, parameter, "final");
            }
        }

        public void visitForeachStatement(PsiForeachStatement statement) {
            super.visitForeachStatement(statement);
            PsiParameter parameter = statement.getIterationParameter();
            if (!parameter.hasModifierProperty("final")) {
                return;
            }
            if (VariableAccessUtils.variableIsUsedInInnerClass((PsiVariable)parameter, (PsiElement)statement)) {
                return;
            }
            this.registerModifierError("final", (PsiModifierListOwner)parameter, parameter, "final");
        }
    }
}

