/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class TypeParameterExtendsObjectInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("type.parameter.extends.object.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/TypeParameterExtendsObjectInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getID() {
        if ("TypeParameterExplicitlyExtendsObject" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/TypeParameterExtendsObjectInspection.getID must not return null");
        }
        return "TypeParameterExplicitlyExtendsObject";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string;
        Integer type = (Integer)infos[0];
        if (type == 1) {
            string = InspectionGadgetsBundle.message("type.parameter.extends.object.problem.descriptor1", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/style/TypeParameterExtendsObjectInspection.buildErrorString must not return null");
            return string;
        }
        string = InspectionGadgetsBundle.message("type.parameter.extends.object.problem.descriptor2", new Object[0]);
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/siyeh/ig/style/TypeParameterExtendsObjectInspection.buildErrorString must not return null");
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ExtendsObjectFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ExtendsObjectVisitor();
    }

    private static class ExtendsObjectVisitor
    extends BaseInspectionVisitor {
        private ExtendsObjectVisitor() {
        }

        public void visitTypeParameter(PsiTypeParameter parameter) {
            super.visitTypeParameter(parameter);
            PsiClassType[] extendsListTypes = parameter.getExtendsListTypes();
            if (extendsListTypes.length != 1) {
                return;
            }
            PsiClassType extendsType = extendsListTypes[0];
            if (!extendsType.equalsToText("java.lang.Object")) {
                return;
            }
            PsiIdentifier nameIdentifier = parameter.getNameIdentifier();
            if (nameIdentifier == null) {
                return;
            }
            this.registerError((PsiElement)nameIdentifier, 1);
        }

        public void visitTypeElement(PsiTypeElement typeElement) {
            super.visitTypeElement(typeElement);
            PsiElement lastChild = typeElement.getLastChild();
            if (!(lastChild instanceof PsiTypeElement)) {
                return;
            }
            PsiType type = typeElement.getType();
            if (!(type instanceof PsiWildcardType)) {
                return;
            }
            PsiWildcardType wildcardType = (PsiWildcardType)type;
            if (!wildcardType.isExtends()) {
                return;
            }
            PsiType extendsBound = wildcardType.getBound();
            if (!TypeUtils.isJavaLangObject(extendsBound)) {
                return;
            }
            PsiElement firstChild = typeElement.getFirstChild();
            if (firstChild == null) {
                return;
            }
            this.registerError(firstChild, 2);
        }
    }

    private static class ExtendsObjectFix
    extends InspectionGadgetsFix {
        private ExtendsObjectFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("extends.object.remove.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/style/TypeParameterExtendsObjectInspection$ExtendsObjectFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(@NotNull Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/style/TypeParameterExtendsObjectInspection$ExtendsObjectFix.doFix must not be null");
            }
            PsiElement identifier = descriptor.getPsiElement();
            PsiElement parent = identifier.getParent();
            if (parent instanceof PsiTypeParameter) {
                PsiJavaCodeReferenceElement[] referenceElements;
                PsiTypeParameter typeParameter = (PsiTypeParameter)parent;
                PsiReferenceList extendsList = typeParameter.getExtendsList();
                for (PsiJavaCodeReferenceElement referenceElement : referenceElements = extendsList.getReferenceElements()) {
                    ExtendsObjectFix.deleteElement((PsiElement)referenceElement);
                }
            } else {
                PsiTypeElement typeElement = (PsiTypeElement)parent;
                PsiElement child = typeElement.getLastChild();
                while (child != null) {
                    PsiJavaToken javaToken;
                    IElementType tokenType;
                    if (child instanceof PsiJavaToken && (tokenType = (javaToken = (PsiJavaToken)child).getTokenType()) == JavaTokenType.QUEST) {
                        return;
                    }
                    child.delete();
                    child = typeElement.getLastChild();
                }
            }
        }
    }
}

