/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class RedundantFieldInitializationInspection
extends BaseInspection {
    @NonNls
    private static final Set<String> s_defaultValues = new HashSet<String>(10);

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("redundant.field.initialization.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/RedundantFieldInitializationInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new RedundantFieldInitializationVisitor();
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("redundant.field.initialization.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/RedundantFieldInitializationInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new RedundantFieldInitializationFix();
    }

    static {
        s_defaultValues.add("null");
        s_defaultValues.add("0");
        s_defaultValues.add("false");
        s_defaultValues.add("0.0");
        s_defaultValues.add("0.0F");
        s_defaultValues.add("0.0f");
        s_defaultValues.add("0L");
        s_defaultValues.add("0l");
        s_defaultValues.add("0x0");
        s_defaultValues.add("0X0");
    }

    private static class RedundantFieldInitializationVisitor
    extends BaseInspectionVisitor {
        private RedundantFieldInitializationVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/style/RedundantFieldInitializationInspection$RedundantFieldInitializationVisitor.visitField must not be null");
            }
            super.visitField(field);
            if (!field.hasInitializer()) {
                return;
            }
            if (field.hasModifierProperty("final")) {
                return;
            }
            PsiExpression initializer = field.getInitializer();
            if (initializer == null) {
                return;
            }
            String text = initializer.getText();
            if (!s_defaultValues.contains(text)) {
                return;
            }
            PsiType type = field.getType();
            if (!(type instanceof PsiPrimitiveType) && !text.equals("null")) {
                return;
            }
            this.registerError((PsiElement)initializer, new Object[0]);
        }
    }

    private static class RedundantFieldInitializationFix
    extends InspectionGadgetsFix {
        private RedundantFieldInitializationFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("redundant.field.initialization.remove.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/style/RedundantFieldInitializationInspection$RedundantFieldInitializationFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiExpression expression = (PsiExpression)descriptor.getPsiElement();
            PsiElement prevSibling = expression.getPrevSibling();
            PsiElement assignment = null;
            do {
                assert (prevSibling != null);
                PsiElement newPrevSibling = prevSibling.getPrevSibling();
                RedundantFieldInitializationFix.deleteElement(prevSibling);
                String text = prevSibling.getText();
                if ("=".equals(text)) {
                    assignment = prevSibling;
                }
                prevSibling = newPrevSibling;
            } while (assignment == null);
            RedundantFieldInitializationFix.deleteElement((PsiElement)expression);
        }
    }
}

