/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.util.Query;
import com.siyeh.ig.psiutils.LibraryUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;

public class MethodInheritanceUtils {
    private MethodInheritanceUtils() {
    }

    public static Set<PsiMethod> calculateSiblingMethods(PsiMethod method) {
        HashSet<PsiMethod> siblingMethods = new HashSet<PsiMethod>();
        Stack<PsiMethod> pendingMethods = new Stack<PsiMethod>();
        pendingMethods.add(method);
        while (!pendingMethods.isEmpty()) {
            PsiMethod[] superMethods;
            PsiMethod methodToAnalyze = (PsiMethod)pendingMethods.pop();
            siblingMethods.add(methodToAnalyze);
            SearchScope scope = methodToAnalyze.getUseScope();
            Query search = OverridingMethodsSearch.search((PsiMethod)methodToAnalyze, (SearchScope)scope, (boolean)true);
            for (PsiMethod overridingMethod : search) {
                if (siblingMethods.contains(overridingMethod) || pendingMethods.contains(overridingMethod)) continue;
                pendingMethods.add(overridingMethod);
            }
            for (PsiMethod superMethod : superMethods = methodToAnalyze.findSuperMethods()) {
                if (siblingMethods.contains(superMethod) || pendingMethods.contains(superMethod)) continue;
                pendingMethods.add(superMethod);
            }
        }
        return siblingMethods;
    }

    public static boolean hasSiblingMethods(PsiMethod method) {
        SearchScope scope = method.getUseScope();
        PsiMethod overridingMethod = (PsiMethod)OverridingMethodsSearch.search((PsiMethod)method, (SearchScope)scope, (boolean)true).findFirst();
        if (overridingMethod != null) {
            return true;
        }
        PsiMethod[] superMethods = method.findSuperMethods();
        return superMethods.length != 0;
    }

    public static boolean inheritsFromLibraryMethod(PsiMethod method) {
        Set<PsiMethod> superMethods = MethodInheritanceUtils.calculateSiblingMethods(method);
        for (PsiMethod superMethod : superMethods) {
            if (!LibraryUtil.classIsInLibrary(superMethod.getContainingClass())) continue;
            return true;
        }
        return false;
    }

    public static Set<RefMethod> calculateSiblingMethods(RefMethod method) {
        HashSet<RefMethod> siblingMethods = new HashSet<RefMethod>();
        Stack<RefMethod> pendingMethods = new Stack<RefMethod>();
        pendingMethods.add(method);
        while (!pendingMethods.isEmpty()) {
            RefMethod methodToAnalyze = (RefMethod)pendingMethods.pop();
            siblingMethods.add(methodToAnalyze);
            Collection overridingMethods = methodToAnalyze.getDerivedMethods();
            for (RefMethod overridingMethod : overridingMethods) {
                if (siblingMethods.contains(overridingMethod) || pendingMethods.contains(overridingMethod)) continue;
                pendingMethods.add(overridingMethod);
            }
            Collection superMethods = methodToAnalyze.getSuperMethods();
            for (RefMethod superMethod : superMethods) {
                if (siblingMethods.contains(superMethod) || pendingMethods.contains(superMethod)) continue;
                pendingMethods.add(superMethod);
            }
        }
        return siblingMethods;
    }
}

