/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.NotNull;

public class CloneUtils {
    private CloneUtils() {
    }

    public static boolean isCloneable(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/CloneUtils.isCloneable must not be null");
        }
        return ClassUtils.isSubclass(aClass, "java.lang.Cloneable");
    }

    public static boolean isDirectlyCloneable(@NotNull PsiClass aClass) {
        PsiClass[] interfaces;
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/CloneUtils.isDirectlyCloneable must not be null");
        }
        for (PsiClass anInterface : interfaces = aClass.getInterfaces()) {
            String qualifiedName;
            if (anInterface == null || !"java.lang.Cloneable".equals(qualifiedName = anInterface.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isClone(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/CloneUtils.isClone must not be null");
        }
        PsiClassType javaLangObject = !PsiUtil.isLanguageLevel5OrHigher((PsiElement)method) ? PsiType.getJavaLangObject((PsiManager)method.getManager(), (GlobalSearchScope)method.getResolveScope()) : null;
        return MethodUtils.methodMatches(method, null, (PsiType)javaLangObject, "clone", PsiType.EMPTY_ARRAY);
    }

    public static boolean onlyThrowsCloneNotSupportedException(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/CloneUtils.onlyThrowsCloneNotSupportedException must not be null");
        }
        PsiCodeBlock body = method.getBody();
        if (body == null) {
            return false;
        }
        PsiStatement[] statements = body.getStatements();
        if (statements.length != 1) {
            return false;
        }
        PsiStatement statement = statements[0];
        if (!(statement instanceof PsiThrowStatement)) {
            return false;
        }
        PsiThrowStatement throwStatement = (PsiThrowStatement)statement;
        PsiExpression exception = throwStatement.getException();
        if (!(exception instanceof PsiNewExpression)) {
            return false;
        }
        PsiNewExpression newExpression = (PsiNewExpression)exception;
        PsiJavaCodeReferenceElement classReference = newExpression.getClassReference();
        if (classReference == null) {
            return false;
        }
        String qualifiedName = classReference.getQualifiedName();
        return qualifiedName.equals("java.lang.CloneNotSupportedException");
    }
}

