/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrayContentsAssignedVisitor
extends JavaRecursiveElementVisitor {
    private boolean assigned;
    private final PsiVariable variable;

    public ArrayContentsAssignedVisitor(@NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ArrayContentsAssignedVisitor.<init> must not be null");
        }
        this.assigned = false;
        this.variable = variable;
    }

    public void visitAssignmentExpression(@NotNull PsiAssignmentExpression assignment) {
        if (assignment == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ArrayContentsAssignedVisitor.visitAssignmentExpression must not be null");
        }
        if (this.assigned) {
            return;
        }
        super.visitAssignmentExpression(assignment);
        PsiExpression lhs = assignment.getLExpression();
        PsiExpression arrayExpression = ArrayContentsAssignedVisitor.getDeepArrayExpression(lhs);
        if (!(arrayExpression instanceof PsiReferenceExpression)) {
            return;
        }
        PsiElement referent = ((PsiReference)arrayExpression).resolve();
        if (referent == null) {
            return;
        }
        if (referent.equals(this.variable)) {
            this.assigned = true;
        }
    }

    public void visitPrefixExpression(@NotNull PsiPrefixExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ArrayContentsAssignedVisitor.visitPrefixExpression must not be null");
        }
        if (this.assigned) {
            return;
        }
        super.visitPrefixExpression(expression);
        PsiJavaToken operationSign = expression.getOperationSign();
        IElementType tokenType = operationSign.getTokenType();
        if (!tokenType.equals(JavaTokenType.PLUSPLUS) && !tokenType.equals(JavaTokenType.MINUSMINUS)) {
            return;
        }
        PsiExpression operand = expression.getOperand();
        PsiExpression arrayExpression = ArrayContentsAssignedVisitor.getDeepArrayExpression(operand);
        if (!(arrayExpression instanceof PsiReferenceExpression)) {
            return;
        }
        PsiElement referent = ((PsiReference)arrayExpression).resolve();
        if (referent == null) {
            return;
        }
        if (referent.equals(this.variable)) {
            this.assigned = true;
        }
    }

    public void visitPostfixExpression(@NotNull PsiPostfixExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ArrayContentsAssignedVisitor.visitPostfixExpression must not be null");
        }
        if (this.assigned) {
            return;
        }
        super.visitPostfixExpression(expression);
        PsiJavaToken operationSign = expression.getOperationSign();
        IElementType tokenType = operationSign.getTokenType();
        if (!tokenType.equals(JavaTokenType.PLUSPLUS) && !tokenType.equals(JavaTokenType.MINUSMINUS)) {
            return;
        }
        PsiExpression operand = expression.getOperand();
        PsiExpression arrayExpression = ArrayContentsAssignedVisitor.getDeepArrayExpression(operand);
        if (!(arrayExpression instanceof PsiReferenceExpression)) {
            return;
        }
        PsiElement referent = ((PsiReference)arrayExpression).resolve();
        if (referent == null) {
            return;
        }
        if (referent.equals(this.variable)) {
            this.assigned = true;
        }
    }

    @Nullable
    private static PsiExpression getDeepArrayExpression(PsiExpression expression) {
        if (!(expression instanceof PsiArrayAccessExpression)) {
            return null;
        }
        PsiExpression arrayExpression = ((PsiArrayAccessExpression)expression).getArrayExpression();
        while (arrayExpression instanceof PsiArrayAccessExpression) {
            PsiArrayAccessExpression arrayAccessExpression = (PsiArrayAccessExpression)arrayExpression;
            arrayExpression = arrayAccessExpression.getArrayExpression();
        }
        return arrayExpression;
    }

    public boolean isAssigned() {
        return this.assigned;
    }
}

