/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.performance.VariableIsModifiedVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;

public class StringBufferReplaceableByStringInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("string.buffer.replaceable.by.string.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/StringBufferReplaceableByStringInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("string.buffer.replaceable.by.string.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/StringBufferReplaceableByStringInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringBufferReplaceableByStringBuilderVisitor();
    }

    private static class StringBufferReplaceableByStringBuilderVisitor
    extends BaseInspectionVisitor {
        private StringBufferReplaceableByStringBuilderVisitor() {
        }

        public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
            if (variable == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/performance/StringBufferReplaceableByStringInspection$StringBufferReplaceableByStringBuilderVisitor.visitLocalVariable must not be null");
            }
            super.visitLocalVariable(variable);
            PsiCodeBlock codeBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
            if (codeBlock == null) {
                return;
            }
            PsiType type = variable.getType();
            if (!TypeUtils.typeEquals("java.lang.StringBuffer", type) && !TypeUtils.typeEquals("java.lang.StringBuilder", type)) {
                return;
            }
            PsiExpression initializer = variable.getInitializer();
            if (initializer == null) {
                return;
            }
            if (!StringBufferReplaceableByStringBuilderVisitor.isNewStringBufferOrStringBuilder(initializer)) {
                return;
            }
            if (VariableAccessUtils.variableIsAssigned((PsiVariable)variable, (PsiElement)codeBlock)) {
                return;
            }
            if (VariableAccessUtils.variableIsAssignedFrom((PsiVariable)variable, (PsiElement)codeBlock)) {
                return;
            }
            if (VariableAccessUtils.variableIsReturned((PsiVariable)variable, (PsiElement)codeBlock)) {
                return;
            }
            if (VariableAccessUtils.variableIsPassedAsMethodArgument((PsiVariable)variable, (PsiElement)codeBlock)) {
                return;
            }
            if (StringBufferReplaceableByStringBuilderVisitor.variableIsModified((PsiVariable)variable, (PsiElement)codeBlock)) {
                return;
            }
            this.registerVariableError((PsiVariable)variable, new Object[0]);
        }

        public static boolean variableIsModified(PsiVariable variable, PsiElement context) {
            VariableIsModifiedVisitor visitor = new VariableIsModifiedVisitor(variable);
            context.accept((PsiElementVisitor)visitor);
            return visitor.isModified();
        }

        private static boolean isNewStringBufferOrStringBuilder(PsiExpression expression) {
            if (expression == null) {
                return false;
            }
            if (expression instanceof PsiNewExpression) {
                return true;
            }
            if (expression instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
                if (!VariableIsModifiedVisitor.isStringBufferUpdate(methodCallExpression)) {
                    return false;
                }
                PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
                PsiExpression qualifier = methodExpression.getQualifierExpression();
                return StringBufferReplaceableByStringBuilderVisitor.isNewStringBufferOrStringBuilder(qualifier);
            }
            return false;
        }
    }
}

