/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class StringBufferMustHaveInitialCapacityInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("StringBufferWithoutInitialCapacity" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/StringBufferMustHaveInitialCapacityInspection.getID must not return null");
        }
        return "StringBufferWithoutInitialCapacity";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("string.buffer.must.have.initial.capacity.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/StringBufferMustHaveInitialCapacityInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("string.buffer.must.have.initial.capacity.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/StringBufferMustHaveInitialCapacityInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringBufferInitialCapacityVisitor();
    }

    private static class StringBufferInitialCapacityVisitor
    extends BaseInspectionVisitor {
        private StringBufferInitialCapacityVisitor() {
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/performance/StringBufferMustHaveInitialCapacityInspection$StringBufferInitialCapacityVisitor.visitNewExpression must not be null");
            }
            super.visitNewExpression(expression);
            PsiType type = expression.getType();
            if (!TypeUtils.typeEquals("java.lang.StringBuffer", type) && !TypeUtils.typeEquals("java.lang.StringBuilder", type)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] args = argumentList.getExpressions();
            if (args.length != 0) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }
    }
}

