/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SizeReplaceableByIsEmptyInspection
extends BaseInspection {
    public boolean ignoreNegations = false;

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("size.replaceable.by.isempty.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/SizeReplaceableByIsEmptyInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("size.replaceable.by.isempty.problem.descriptor", infos[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/SizeReplaceableByIsEmptyInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("size.replaceable.by.isempty.negation.ignore.option", new Object[0]), (InspectionProfileEntry)this, "ignoreNegations");
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new SizeReplaceableByIsEmptyFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SizeReplaceableByIsEmptyVisitor();
    }

    private class SizeReplaceableByIsEmptyVisitor
    extends BaseInspectionVisitor {
        @NonNls
        private String isEmptyCall = "";

        private SizeReplaceableByIsEmptyVisitor() {
        }

        public void visitBinaryExpression(PsiBinaryExpression expression) {
            PsiJavaToken sign;
            super.visitBinaryExpression(expression);
            PsiExpression rhs = expression.getROperand();
            if (rhs == null) {
                return;
            }
            if (!ComparisonUtils.isComparison((PsiExpression)expression)) {
                return;
            }
            PsiExpression lhs = expression.getLOperand();
            if (lhs instanceof PsiMethodCallExpression) {
                PsiJavaToken sign2 = expression.getOperationSign();
                if (this.canBeReplacedByIsEmpty(lhs, sign2, rhs, false)) {
                    this.registerError((PsiElement)expression, this.isEmptyCall);
                }
            } else if (rhs instanceof PsiMethodCallExpression && this.canBeReplacedByIsEmpty(rhs, sign = expression.getOperationSign(), lhs, true)) {
                this.registerError((PsiElement)expression, this.isEmptyCall);
            }
        }

        private boolean canBeReplacedByIsEmpty(PsiExpression lhs, PsiJavaToken sign, PsiExpression rhs, boolean flipped) {
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)lhs;
            if (!this.isSizeCall(callExpression)) {
                return false;
            }
            Object object = ExpressionUtils.computeConstantExpression(rhs);
            if (!(object instanceof Integer)) {
                return false;
            }
            Integer integer = (Integer)object;
            int constant = integer;
            if (constant != 0) {
                return false;
            }
            IElementType tokenType = sign.getTokenType();
            if (JavaTokenType.EQEQ.equals(tokenType)) {
                return true;
            }
            if (SizeReplaceableByIsEmptyInspection.this.ignoreNegations) {
                return false;
            }
            this.isEmptyCall = '!' + this.isEmptyCall;
            if (JavaTokenType.NE.equals(tokenType)) {
                return true;
            }
            return flipped ? JavaTokenType.LT.equals(tokenType) : JavaTokenType.GT.equals(tokenType);
        }

        private boolean isSizeCall(PsiMethodCallExpression callExpression) {
            PsiMethod[] methods;
            PsiReferenceExpression methodExpression = callExpression.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            if (!"size".equals(referenceName)) {
                return false;
            }
            PsiExpressionList argumentList = callExpression.getArgumentList();
            PsiExpression[] expressions = argumentList.getExpressions();
            if (expressions.length != 0) {
                return false;
            }
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            if (qualifierExpression == null) {
                return false;
            }
            this.isEmptyCall = qualifierExpression.getText() + ".isEmpty()";
            PsiType type = qualifierExpression.getType();
            if (!(type instanceof PsiClassType)) {
                return false;
            }
            PsiClassType classType = (PsiClassType)type;
            PsiClass aClass = classType.resolve();
            if (aClass == null) {
                return false;
            }
            for (PsiMethod method : methods = aClass.findMethodsByName("isEmpty", true)) {
                PsiParameterList parameterList = method.getParameterList();
                if (parameterList.getParametersCount() != 0) continue;
                return true;
            }
            return false;
        }
    }

    private static class SizeReplaceableByIsEmptyFix
    extends InspectionGadgetsFix {
        private SizeReplaceableByIsEmptyFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("size.replaceable.by.isempty.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/performance/SizeReplaceableByIsEmptyInspection$SizeReplaceableByIsEmptyFix.getName must not return null");
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)descriptor.getPsiElement();
            PsiExpression operand = binaryExpression.getLOperand();
            if (!(operand instanceof PsiMethodCallExpression)) {
                operand = binaryExpression.getROperand();
            }
            if (!(operand instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)operand;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            if (qualifierExpression == null) {
                return;
            }
            String newExpression = qualifierExpression.getText();
            PsiJavaToken sign = binaryExpression.getOperationSign();
            IElementType tokenType = sign.getTokenType();
            if (!JavaTokenType.EQEQ.equals(tokenType)) {
                newExpression = '!' + newExpression;
            }
            newExpression = newExpression + ".isEmpty()";
            SizeReplaceableByIsEmptyFix.replaceExpression((PsiExpression)binaryExpression, newExpression);
        }
    }
}

