/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleIntegerFieldOptionsPanel;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.ExtractMethodFix;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class OverlyComplexArithmeticExpressionInspection
extends BaseInspection {
    private static final int TERM_LIMIT = 6;
    public int m_limit = 6;
    private static final Set<String> arithmeticTokens = new HashSet<String>(5);

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("overly.complex.arithmetic.expression.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/numeric/OverlyComplexArithmeticExpressionInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("overly.complex.arithmetic.expression.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/numeric/OverlyComplexArithmeticExpressionInspection.buildErrorString must not return null");
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        return new SingleIntegerFieldOptionsPanel(InspectionGadgetsBundle.message("overly.complex.arithmetic.expression.max.number.option", new Object[0]), (InspectionProfileEntry)this, "m_limit");
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ExtractMethodFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SwitchStatementWithTooManyBranchesVisitor();
    }

    static {
        arithmeticTokens.add("+");
        arithmeticTokens.add("-");
        arithmeticTokens.add("*");
        arithmeticTokens.add("/");
        arithmeticTokens.add("%");
    }

    private class SwitchStatementWithTooManyBranchesVisitor
    extends BaseInspectionVisitor {
        private SwitchStatementWithTooManyBranchesVisitor() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/numeric/OverlyComplexArithmeticExpressionInspection$SwitchStatementWithTooManyBranchesVisitor.visitBinaryExpression must not be null");
            }
            super.visitBinaryExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitPrefixExpression(@NotNull PsiPrefixExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/numeric/OverlyComplexArithmeticExpressionInspection$SwitchStatementWithTooManyBranchesVisitor.visitPrefixExpression must not be null");
            }
            super.visitPrefixExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        public void visitParenthesizedExpression(PsiParenthesizedExpression expression) {
            super.visitParenthesizedExpression(expression);
            this.checkExpression((PsiExpression)expression);
        }

        private void checkExpression(PsiExpression expression) {
            if (this.isParentArithmetic(expression)) {
                return;
            }
            if (!this.isArithmetic(expression)) {
                return;
            }
            int numTerms = this.countTerms(expression);
            if (numTerms <= OverlyComplexArithmeticExpressionInspection.this.m_limit) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }

        private int countTerms(PsiExpression expression) {
            if (!this.isArithmetic(expression)) {
                return 1;
            }
            if (expression instanceof PsiBinaryExpression) {
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
                PsiExpression lhs = binaryExpression.getLOperand();
                PsiExpression rhs = binaryExpression.getROperand();
                return this.countTerms(lhs) + this.countTerms(rhs);
            }
            if (expression instanceof PsiPrefixExpression) {
                PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression;
                PsiExpression operand = prefixExpression.getOperand();
                return this.countTerms(operand);
            }
            if (expression instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression;
                PsiExpression contents = parenthesizedExpression.getExpression();
                return this.countTerms(contents);
            }
            return 1;
        }

        private boolean isParentArithmetic(PsiExpression expression) {
            PsiElement parent = expression.getParent();
            if (!(parent instanceof PsiExpression)) {
                return false;
            }
            return this.isArithmetic((PsiExpression)parent);
        }

        private boolean isArithmetic(PsiExpression expression) {
            if (expression instanceof PsiBinaryExpression) {
                PsiType type = expression.getType();
                if (TypeUtils.isJavaLangString(type)) {
                    return false;
                }
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
                PsiJavaToken sign = binaryExpression.getOperationSign();
                String signText = sign.getText();
                return arithmeticTokens.contains(signText);
            }
            if (expression instanceof PsiPrefixExpression) {
                PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression;
                PsiJavaToken sign = prefixExpression.getOperationSign();
                String signText = sign.getText();
                return arithmeticTokens.contains(signText);
            }
            if (expression instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression;
                PsiExpression contents = parenthesizedExpression.getExpression();
                return this.isArithmetic(contents);
            }
            return false;
        }
    }
}

