/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiTypeParameter;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import com.siyeh.ig.naming.ConventionInspection;
import org.jetbrains.annotations.NotNull;

public class TypeParameterNamingConventionInspection
extends ConventionInspection {
    private static final int DEFAULT_MIN_LENGTH = 1;
    private static final int DEFAULT_MAX_LENGTH = 1;

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("type.parameter.naming.convention.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/TypeParameterNamingConventionInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RenameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string;
        String parameterName = (String)infos[0];
        if (parameterName.length() < this.getMinLength()) {
            string = InspectionGadgetsBundle.message("type.parameter.naming.convention.problem.descriptor.short", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/TypeParameterNamingConventionInspection.buildErrorString must not return null");
            return string;
        }
        if (parameterName.length() > this.getMaxLength()) {
            string = InspectionGadgetsBundle.message("type.parameter.naming.convention.problem.descriptor.long", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/TypeParameterNamingConventionInspection.buildErrorString must not return null");
            return string;
        }
        string = InspectionGadgetsBundle.message("enumerated.class.naming.convention.problem.descriptor.regex.mismatch", this.getRegex());
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/TypeParameterNamingConventionInspection.buildErrorString must not return null");
    }

    @Override
    protected String getDefaultRegex() {
        return "[A-Z][A-Za-z\\d]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 1;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 1;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NamingConventionsVisitor();
    }

    private class NamingConventionsVisitor
    extends BaseInspectionVisitor {
        private NamingConventionsVisitor() {
        }

        public void visitTypeParameter(PsiTypeParameter parameter) {
            super.visitTypeParameter(parameter);
            String name = parameter.getName();
            if (name == null) {
                return;
            }
            if (TypeParameterNamingConventionInspection.this.isValid(name)) {
                return;
            }
            PsiIdentifier nameIdentifier = parameter.getNameIdentifier();
            if (nameIdentifier == null) {
                return;
            }
            this.registerError((PsiElement)nameIdentifier, name);
        }
    }
}

