/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameParameterFix;
import com.siyeh.ig.psiutils.LibraryUtil;
import com.siyeh.ig.ui.MultipleCheckboxOptionsPanel;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterNameDiffersFromOverriddenParameterInspection
extends BaseInspection {
    public boolean m_ignoreSingleCharacterNames = false;
    public boolean m_ignoreOverridesOfLibraryMethods = false;

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("parameter.name.differs.from.overridden.parameter.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/ParameterNameDiffersFromOverriddenParameterInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("parameter.name.differs.from.overridden.parameter.problem.descriptor", infos[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/ParameterNameDiffersFromOverriddenParameterInspection.buildErrorString must not return null");
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel(this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("parameter.name.differs.from.overridden.parameter.ignore.character.option", new Object[0]), "m_ignoreSingleCharacterNames");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("parameter.name.differs.from.overridden.parameter.ignore.library.option", new Object[0]), "m_ignoreOverridesOfLibraryMethods");
        return optionsPanel;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RenameParameterFix((String)infos[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ParameterNameDiffersFromOverriddenParameterVisitor();
    }

    private class ParameterNameDiffersFromOverriddenParameterVisitor
    extends BaseInspectionVisitor {
        private ParameterNameDiffersFromOverriddenParameterVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/naming/ParameterNameDiffersFromOverriddenParameterInspection$ParameterNameDiffersFromOverriddenParameterVisitor.visitMethod must not be null");
            }
            PsiParameterList parameterList = method.getParameterList();
            if (parameterList.getParametersCount() == 0) {
                return;
            }
            Query query = SuperMethodsSearch.search((PsiMethod)method, (PsiClass)method.getContainingClass(), (boolean)true, (boolean)false);
            MethodSignatureBackedByPsiMethod methodSignature = (MethodSignatureBackedByPsiMethod)query.findFirst();
            if (methodSignature == null) {
                return;
            }
            PsiMethod superMethod = methodSignature.getMethod();
            PsiParameter[] parameters = parameterList.getParameters();
            this.checkParameters(superMethod, parameters);
        }

        private void checkParameters(PsiMethod superMethod, PsiParameter[] parameters) {
            PsiClass containingClass;
            if (ParameterNameDiffersFromOverriddenParameterInspection.this.m_ignoreOverridesOfLibraryMethods && (containingClass = superMethod.getContainingClass()) != null && LibraryUtil.classIsInLibrary(containingClass)) {
                return;
            }
            PsiParameterList superParameterList = superMethod.getParameterList();
            PsiParameter[] superParameters = superParameterList.getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                PsiParameter parameter = parameters[i];
                String parameterName = parameter.getName();
                String superParameterName = superParameters[i].getName();
                if (superParameterName == null || superParameterName.equals(parameterName) || ParameterNameDiffersFromOverriddenParameterInspection.this.m_ignoreSingleCharacterNames && superParameterName.length() == 1) continue;
                this.registerVariableError((PsiVariable)parameter, superParameterName);
            }
        }
    }
}

