/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import org.jetbrains.annotations.NotNull;

public class MethodNamesDifferOnlyByCaseInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("MethodNamesDifferingOnlyByCase" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/MethodNamesDifferOnlyByCaseInspection.getID must not return null");
        }
        return "MethodNamesDifferingOnlyByCase";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("method.names.differ.only.by.case.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/MethodNamesDifferOnlyByCaseInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("method.names.differ.only.by.case.problem.descriptor", infos[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/MethodNamesDifferOnlyByCaseInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new OverloadedMethodsWithSameNumberOfParametersVisitor();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RenameFix();
    }

    private static class OverloadedMethodsWithSameNumberOfParametersVisitor
    extends BaseInspectionVisitor {
        private OverloadedMethodsWithSameNumberOfParametersVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            PsiMethod[] methods;
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/naming/MethodNamesDifferOnlyByCaseInspection$OverloadedMethodsWithSameNumberOfParametersVisitor.visitMethod must not be null");
            }
            if (method.isConstructor()) {
                return;
            }
            PsiIdentifier nameIdentifier = method.getNameIdentifier();
            if (nameIdentifier == null) {
                return;
            }
            String methodName = method.getName();
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            for (PsiMethod testMethod : methods = aClass.getMethods()) {
                String testMethodName = testMethod.getName();
                if (methodName.equals(testMethodName) || !methodName.equalsIgnoreCase(testMethodName)) continue;
                this.registerError((PsiElement)nameIdentifier, testMethodName);
            }
        }
    }
}

