/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.methodmetrics.MethodMetricInspection;
import com.siyeh.ig.methodmetrics.ReturnPointCountVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.ui.ToggleAction;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class MultipleReturnPointsPerMethodInspection
extends MethodMetricInspection {
    public boolean ignoreGuardClauses = false;
    public boolean ignoreEqualsMethod = false;

    @NotNull
    public String getID() {
        if ("MethodWithMultipleReturnPoints" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/methodmetrics/MultipleReturnPointsPerMethodInspection.getID must not return null");
        }
        return "MethodWithMultipleReturnPoints";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("multiple.return.points.per.method.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/methodmetrics/MultipleReturnPointsPerMethodInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    protected int getDefaultLimit() {
        return 1;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionGadgetsBundle.message("return.point.limit.option", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer returnPointCount = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("multiple.return.points.per.method.problem.descriptor", returnPointCount);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/methodmetrics/MultipleReturnPointsPerMethodInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public JComponent createOptionsPanel() {
        Form form = new Form();
        return form.getContentPanel();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MultipleReturnPointsPerMethodVisitor();
    }

    private class Form {
        private JPanel contentPanel;
        private JFormattedTextField valueField;
        private JCheckBox ignoreGuardClausesCheckBox;
        private JCheckBox ignoreForEqualsMethodsCheckBox;

        private Form() {
            this.$$$setupUI$$$();
        }

        private void createUIComponents() {
            this.valueField = MultipleReturnPointsPerMethodInspection.this.prepareNumberEditor("m_limit");
            this.ignoreGuardClausesCheckBox = new JCheckBox(new ToggleAction(InspectionGadgetsBundle.message("ignore.guard.clauses", new Object[0]), MultipleReturnPointsPerMethodInspection.this, "ignoreGuardClauses"));
            this.ignoreGuardClausesCheckBox.setSelected(MultipleReturnPointsPerMethodInspection.this.ignoreGuardClauses);
            this.ignoreForEqualsMethodsCheckBox = new JCheckBox(new ToggleAction(InspectionGadgetsBundle.message("ignore.for.equals.methods", new Object[0]), MultipleReturnPointsPerMethodInspection.this, "ignoreEqualsMethod"));
            this.ignoreForEqualsMethodsCheckBox.setSelected(MultipleReturnPointsPerMethodInspection.this.ignoreEqualsMethod);
        }

        public JComponent getContentPanel() {
            return this.contentPanel;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JPanel jPanel;
            this.createUIComponents();
            this.contentPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(4, 4, 4, 4), 4, 4, false, false));
            ((Component)jPanel).setEnabled(true);
            JLabel jLabel = new JLabel();
            this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("com/siyeh/InspectionGadgetsBundle").getString("return.point.limit.option"));
            jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            JFormattedTextField jFormattedTextField = this.valueField;
            jPanel.add((Component)jFormattedTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 0, 0, null, new Dimension(30, -1), null));
            Spacer spacer2 = new Spacer();
            jPanel.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
            JCheckBox jCheckBox = this.ignoreGuardClausesCheckBox;
            this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("com/siyeh/InspectionGadgetsBundle").getString("ignore.guard.clauses"));
            jPanel.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 3, 8, 0, 3, 0, null, null, null));
            JCheckBox jCheckBox2 = this.ignoreForEqualsMethodsCheckBox;
            this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("com/siyeh/InspectionGadgetsBundle").getString("ignore.for.equals.methods"));
            jPanel.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 3, 8, 0, 3, 0, null, null, null));
            jLabel.setLabelFor(jFormattedTextField);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.contentPanel;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }

    private class MultipleReturnPointsPerMethodVisitor
    extends BaseInspectionVisitor {
        private MultipleReturnPointsPerMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/methodmetrics/MultipleReturnPointsPerMethodInspection$MultipleReturnPointsPerMethodVisitor.visitMethod must not be null");
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            if (MultipleReturnPointsPerMethodInspection.this.ignoreEqualsMethod && MethodUtils.isEquals(method)) {
                return;
            }
            int returnPointCount = this.calculateReturnPointCount(method);
            if (returnPointCount <= MultipleReturnPointsPerMethodInspection.this.getLimit()) {
                return;
            }
            this.registerMethodError(method, returnPointCount);
        }

        private int calculateReturnPointCount(PsiMethod method) {
            ReturnPointCountVisitor visitor = new ReturnPointCountVisitor(MultipleReturnPointsPerMethodInspection.this.ignoreGuardClauses);
            method.accept((PsiElementVisitor)visitor);
            int count = visitor.getCount();
            if (!this.mayFallThroughBottom(method)) {
                return count;
            }
            PsiCodeBlock body = method.getBody();
            if (body == null) {
                return count;
            }
            PsiStatement[] statements = body.getStatements();
            if (statements.length == 0) {
                return count + 1;
            }
            PsiStatement lastStatement = statements[statements.length - 1];
            if (ControlFlowUtils.statementMayCompleteNormally(lastStatement)) {
                return count + 1;
            }
            return count;
        }

        private boolean mayFallThroughBottom(PsiMethod method) {
            if (method.isConstructor()) {
                return true;
            }
            PsiType returnType = method.getReturnType();
            return PsiType.VOID.equals(returnType);
        }
    }
}

