/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.logging;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.RegExInputVerifier;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.jetbrains.annotations.NotNull;

public class ClassWithMultipleLoggersInspection
extends BaseInspection {
    public String loggerClassName = "java.util.logging.Logger";

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("multiple.loggers.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/logging/ClassWithMultipleLoggersInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("multiple.loggers.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/logging/ClassWithMultipleLoggersInspection.buildErrorString must not return null");
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        GridBagLayout layout = new GridBagLayout();
        JPanel panel = new JPanel(layout);
        JLabel classNameLabel = new JLabel(InspectionGadgetsBundle.message("logger.name.option", new Object[0]));
        classNameLabel.setHorizontalAlignment(11);
        final JTextField loggerClassNameField = new JTextField();
        Font panelFont = panel.getFont();
        loggerClassNameField.setFont(panelFont);
        loggerClassNameField.setText(this.loggerClassName);
        loggerClassNameField.setColumns(100);
        loggerClassNameField.setInputVerifier(new RegExInputVerifier());
        DocumentListener listener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.textChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.textChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.textChanged();
            }

            private void textChanged() {
                ClassWithMultipleLoggersInspection.this.loggerClassName = loggerClassNameField.getText();
            }
        };
        Document loggerClassNameDocument = loggerClassNameField.getDocument();
        loggerClassNameDocument.addDocumentListener(listener);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 13;
        constraints.fill = 2;
        panel.add((Component)classNameLabel, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.anchor = 17;
        panel.add((Component)loggerClassNameField, constraints);
        return panel;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ClassWithMultipleLoggersVisitor();
    }

    private class ClassWithMultipleLoggersVisitor
    extends BaseInspectionVisitor {
        private ClassWithMultipleLoggersVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            PsiField[] fields;
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/logging/ClassWithMultipleLoggersInspection$ClassWithMultipleLoggersVisitor.visitClass must not be null");
            }
            if (aClass.isInterface() || aClass.isEnum() || aClass.isAnnotationType()) {
                return;
            }
            if (aClass instanceof PsiTypeParameter) {
                return;
            }
            if (aClass.getContainingClass() != null) {
                return;
            }
            int numLoggers = 0;
            for (PsiField field : fields = aClass.getFields()) {
                if (!this.isLogger(field)) continue;
                ++numLoggers;
            }
            if (numLoggers <= 1) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }

        private boolean isLogger(PsiField field) {
            PsiType type = field.getType();
            String text = type.getCanonicalText();
            return text.equals(ClassWithMultipleLoggersInspection.this.loggerClassName);
        }
    }
}

