/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.TestUtils;
import org.jetbrains.annotations.NotNull;

public class BeforeClassOrAfterClassIsPublicStaticVoidNoArgInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("BeforeOrAfterWithIncorrectSignature" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/BeforeClassOrAfterClassIsPublicStaticVoidNoArgInspection.getID must not return null");
        }
        return "BeforeOrAfterWithIncorrectSignature";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("before.class.or.after.class.is.public.static.void.no.arg.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/BeforeClassOrAfterClassIsPublicStaticVoidNoArgInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("before.class.or.after.class.is.public.static.void.no.arg.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/BeforeClassOrAfterClassIsPublicStaticVoidNoArgInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BeforeClassOrAfterClassIsPublicStaticVoidNoArgVisitor();
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        if (infos.length != 1) {
            return null;
        }
        Object name = infos[0];
        if (!(name instanceof String)) {
            return null;
        }
        return new MakePublicStaticVoidFix((String)name);
    }

    private static class MakePublicStaticVoidFix
    extends InspectionGadgetsFix {
        private final String myName;

        public MakePublicStaticVoidFix(String name) {
            this.myName = name;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiMethod.class);
            if (method != null) {
                PsiModifierList modifierList = method.getModifierList();
                if (!modifierList.hasModifierProperty("public")) {
                    modifierList.setModifierProperty("public", true);
                }
                if (!modifierList.hasModifierProperty("static")) {
                    modifierList.setModifierProperty("static", true);
                }
                if (method.getReturnType() != PsiType.VOID) {
                    ChangeSignatureProcessor csp = new ChangeSignatureProcessor(project, method, false, "public", method.getName(), PsiType.VOID, new ParameterInfoImpl[0]);
                    csp.run();
                }
            }
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/junit/BeforeClassOrAfterClassIsPublicStaticVoidNoArgInspection$MakePublicStaticVoidFix.getName must not return null");
            }
            return string;
        }
    }

    private static class BeforeClassOrAfterClassIsPublicStaticVoidNoArgVisitor
    extends BaseInspectionVisitor {
        private BeforeClassOrAfterClassIsPublicStaticVoidNoArgVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/junit/BeforeClassOrAfterClassIsPublicStaticVoidNoArgInspection$BeforeClassOrAfterClassIsPublicStaticVoidNoArgVisitor.visitMethod must not be null");
            }
            if (!TestUtils.isJUnit4BeforeClassOrAfterClassMethod(method)) {
                return;
            }
            PsiType returnType = method.getReturnType();
            if (returnType == null) {
                return;
            }
            PsiClass targetClass = method.getContainingClass();
            if (targetClass == null) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            if (!(parameterList.getParametersCount() == 0 && returnType.equals(PsiType.VOID) && method.hasModifierProperty("public") && method.hasModifierProperty("static"))) {
                this.registerMethodError(method, "Change signature of '" + PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)267, (int)2) + "' to 'public static void " + method.getName() + "()'");
            }
        }
    }
}

