/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.jdk15;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.StringUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WhileCanBeForeachInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("WhileLoopReplaceableByForEach" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/jdk15/WhileCanBeForeachInspection.getID must not return null");
        }
        return "WhileLoopReplaceableByForEach";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("while.can.be.foreach.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/jdk15/WhileCanBeForeachInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("while.can.be.foreach.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/jdk15/WhileCanBeForeachInspection.buildErrorString must not return null");
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new WhileCanBeForeachFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new WhileCanBeForeachVisitor();
    }

    @Nullable
    public static PsiStatement getPreviousStatement(PsiWhileStatement statement) {
        PsiElement prevStatement = PsiTreeUtil.skipSiblingsBackward((PsiElement)statement, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class});
        if (prevStatement == null || !(prevStatement instanceof PsiStatement)) {
            return null;
        }
        return (PsiStatement)prevStatement;
    }

    private static class IteratorHasNextVisitor
    extends JavaRecursiveElementVisitor {
        private boolean hasNextCalled = false;
        private final PsiVariable iterator;

        private IteratorHasNextVisitor(PsiVariable iterator) {
            this.iterator = iterator;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/jdk15/WhileCanBeForeachInspection$IteratorHasNextVisitor.visitElement must not be null");
            }
            if (!this.hasNextCalled) {
                super.visitElement(element);
            }
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/jdk15/WhileCanBeForeachInspection$IteratorHasNextVisitor.visitMethodCallExpression must not be null");
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if (!"hasNext".equals(name)) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
            PsiElement target = referenceExpression.resolve();
            if (this.iterator.equals(target)) {
                this.hasNextCalled = true;
            }
        }

        public boolean isHasNextCalled() {
            return this.hasNextCalled;
        }
    }

    private static class IteratorRemoveVisitor
    extends JavaRecursiveElementVisitor {
        private boolean removeCalled;
        private final PsiVariable iterator;

        private IteratorRemoveVisitor(@NotNull PsiVariable iterator) {
            if (iterator == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/jdk15/WhileCanBeForeachInspection$IteratorRemoveVisitor.<init> must not be null");
            }
            this.removeCalled = false;
            this.iterator = iterator;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/jdk15/WhileCanBeForeachInspection$IteratorRemoveVisitor.visitElement must not be null");
            }
            if (!this.removeCalled) {
                super.visitElement(element);
            }
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/jdk15/WhileCanBeForeachInspection$IteratorRemoveVisitor.visitMethodCallExpression must not be null");
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if (!"remove".equals(name)) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
            PsiElement target = referenceExpression.resolve();
            if (this.iterator.equals(target)) {
                this.removeCalled = true;
            }
        }

        public boolean isRemoveCalled() {
            return this.removeCalled;
        }
    }

    private static class NumCallsToIteratorNextVisitor
    extends JavaRecursiveElementVisitor {
        private int numCallsToIteratorNext = 0;
        private final PsiVariable iterator;

        private NumCallsToIteratorNextVisitor(PsiVariable iterator) {
            this.iterator = iterator;
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression callExpression) {
            if (callExpression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/jdk15/WhileCanBeForeachInspection$NumCallsToIteratorNextVisitor.visitMethodCallExpression must not be null");
            }
            super.visitMethodCallExpression(callExpression);
            PsiReferenceExpression methodExpression = callExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"next".equals(methodName)) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
            PsiElement target = referenceExpression.resolve();
            if (!this.iterator.equals(target)) {
                return;
            }
            ++this.numCallsToIteratorNext;
        }

        public int getNumCallsToIteratorNext() {
            return this.numCallsToIteratorNext;
        }
    }

    private static class WhileCanBeForeachVisitor
    extends BaseInspectionVisitor {
        private WhileCanBeForeachVisitor() {
        }

        public void visitWhileStatement(@NotNull PsiWhileStatement whileStatement) {
            if (whileStatement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/jdk15/WhileCanBeForeachInspection$WhileCanBeForeachVisitor.visitWhileStatement must not be null");
            }
            super.visitWhileStatement(whileStatement);
            if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)whileStatement)) {
                return;
            }
            if (!WhileCanBeForeachVisitor.isCollectionLoopStatement(whileStatement)) {
                return;
            }
            this.registerStatementError((PsiStatement)whileStatement, new Object[0]);
        }

        private static boolean isCollectionLoopStatement(PsiWhileStatement whileStatement) {
            PsiStatement initialization = WhileCanBeForeachInspection.getPreviousStatement(whileStatement);
            if (initialization == null) {
                return false;
            }
            if (!(initialization instanceof PsiDeclarationStatement)) {
                return false;
            }
            PsiDeclarationStatement declaration = (PsiDeclarationStatement)initialization;
            PsiElement[] declaredElements = declaration.getDeclaredElements();
            if (declaredElements.length != 1) {
                return false;
            }
            PsiElement declaredElement = declaredElements[0];
            if (!(declaredElement instanceof PsiLocalVariable)) {
                return false;
            }
            PsiLocalVariable declaredVariable = (PsiLocalVariable)declaredElement;
            PsiType declaredVariableType = declaredVariable.getType();
            if (!(declaredVariableType instanceof PsiClassType)) {
                return false;
            }
            PsiClassType classType = (PsiClassType)declaredVariableType;
            PsiClass declaredClass = classType.resolve();
            if (declaredClass == null) {
                return false;
            }
            if (!ClassUtils.isSubclass(declaredClass, "java.util.Iterator")) {
                return false;
            }
            PsiExpression initialValue = declaredVariable.getInitializer();
            if (initialValue == null) {
                return false;
            }
            if (!(initialValue instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression initialCall = (PsiMethodCallExpression)initialValue;
            PsiReferenceExpression initialMethodExpression = initialCall.getMethodExpression();
            String initialCallName = initialMethodExpression.getReferenceName();
            if (!"iterator".equals(initialCallName)) {
                return false;
            }
            PsiExpression qualifier = initialMethodExpression.getQualifierExpression();
            if (qualifier == null) {
                return false;
            }
            PsiType qualifierType = qualifier.getType();
            if (!(qualifierType instanceof PsiClassType)) {
                return false;
            }
            PsiClass qualifierClass = ((PsiClassType)qualifierType).resolve();
            if (qualifierClass == null) {
                return false;
            }
            if (!ClassUtils.isSubclass(qualifierClass, "java.lang.Iterable") && !ClassUtils.isSubclass(qualifierClass, "java.util.Collection")) {
                return false;
            }
            PsiExpression condition = whileStatement.getCondition();
            if (!WhileCanBeForeachVisitor.isHasNextCalled((PsiVariable)declaredVariable, condition)) {
                return false;
            }
            PsiStatement body = whileStatement.getBody();
            if (body == null) {
                return false;
            }
            if (WhileCanBeForeachVisitor.calculateCallsToIteratorNext((PsiVariable)declaredVariable, body) != 1) {
                return false;
            }
            if (WhileCanBeForeachVisitor.isIteratorRemoveCalled((PsiVariable)declaredVariable, body)) {
                return false;
            }
            if (WhileCanBeForeachVisitor.isIteratorHasNextCalled((PsiVariable)declaredVariable, body)) {
                return false;
            }
            if (VariableAccessUtils.variableIsAssigned((PsiVariable)declaredVariable, (PsiElement)body)) {
                return false;
            }
            for (PsiElement nextSibling = whileStatement.getNextSibling(); nextSibling != null; nextSibling = nextSibling.getNextSibling()) {
                if (!VariableAccessUtils.variableValueIsUsed((PsiVariable)declaredVariable, nextSibling)) continue;
                return false;
            }
            return true;
        }

        private static boolean isHasNextCalled(PsiVariable iterator, PsiExpression condition) {
            if (!(condition instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)condition;
            PsiExpressionList argumentList = call.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 0) {
                return false;
            }
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"hasNext".equals(methodName)) {
                return false;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return true;
            }
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
            PsiElement target = referenceExpression.resolve();
            return iterator.equals(target);
        }

        private static int calculateCallsToIteratorNext(PsiVariable iterator, PsiStatement body) {
            NumCallsToIteratorNextVisitor visitor = new NumCallsToIteratorNextVisitor(iterator);
            body.accept((PsiElementVisitor)visitor);
            return visitor.getNumCallsToIteratorNext();
        }

        private static boolean isIteratorRemoveCalled(PsiVariable iterator, PsiStatement body) {
            IteratorRemoveVisitor visitor = new IteratorRemoveVisitor(iterator);
            body.accept((PsiElementVisitor)visitor);
            return visitor.isRemoveCalled();
        }

        private static boolean isIteratorHasNextCalled(PsiVariable iterator, PsiStatement body) {
            IteratorHasNextVisitor visitor = new IteratorHasNextVisitor(iterator);
            body.accept((PsiElementVisitor)visitor);
            return visitor.isHasNextCalled();
        }
    }

    private static class WhileCanBeForeachFix
    extends InspectionGadgetsFix {
        private WhileCanBeForeachFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("foreach.replace.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/jdk15/WhileCanBeForeachInspection$WhileCanBeForeachFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement whileElement = descriptor.getPsiElement();
            PsiWhileStatement whileStatement = (PsiWhileStatement)whileElement.getParent();
            WhileCanBeForeachFix.replaceWhileWithForEach(whileStatement);
        }

        private static void replaceWhileWithForEach(@NotNull PsiWhileStatement whileStatement) throws IncorrectOperationException {
            PsiDeclarationStatement statementToSkip;
            String contentVariableName;
            if (whileStatement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/jdk15/WhileCanBeForeachInspection$WhileCanBeForeachFix.replaceWhileWithForEach must not be null");
            }
            PsiStatement body = whileStatement.getBody();
            if (body == null) {
                return;
            }
            PsiStatement initialization = WhileCanBeForeachInspection.getPreviousStatement(whileStatement);
            PsiDeclarationStatement declaration = (PsiDeclarationStatement)initialization;
            if (declaration == null) {
                return;
            }
            PsiElement declaredElement = declaration.getDeclaredElements()[0];
            if (!(declaredElement instanceof PsiLocalVariable)) {
                return;
            }
            PsiLocalVariable iterator = (PsiLocalVariable)declaredElement;
            PsiMethodCallExpression initializer = (PsiMethodCallExpression)iterator.getInitializer();
            if (initializer == null) {
                return;
            }
            PsiReferenceExpression methodExpression = initializer.getMethodExpression();
            PsiExpression collection = methodExpression.getQualifierExpression();
            if (collection == null) {
                return;
            }
            PsiType collectionType = collection.getType();
            if (collectionType == null) {
                return;
            }
            PsiManager manager = collection.getManager();
            PsiType contentType = WhileCanBeForeachFix.getContentType(collectionType, manager);
            if (contentType == null) {
                return;
            }
            Project project = whileStatement.getProject();
            PsiStatement firstStatement = WhileCanBeForeachFix.getFirstStatement(body);
            boolean isDeclaration = WhileCanBeForeachFix.isIteratorNextDeclaration(firstStatement, (PsiVariable)iterator, contentType);
            if (isDeclaration) {
                PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)firstStatement;
                if (declarationStatement == null) {
                    return;
                }
                PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
                PsiLocalVariable localVariable = (PsiLocalVariable)declaredElements[0];
                contentVariableName = localVariable.getName();
                statementToSkip = declarationStatement;
            } else {
                if (collection instanceof PsiReferenceExpression) {
                    PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)collection;
                    String collectionName = referenceElement.getReferenceName();
                    contentVariableName = WhileCanBeForeachFix.createNewVariableName(whileStatement, contentType, collectionName);
                } else {
                    contentVariableName = WhileCanBeForeachFix.createNewVariableName(whileStatement, contentType, null);
                }
                statementToSkip = null;
            }
            CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getSettings((Project)project);
            String finalString = codeStyleSettings.GENERATE_FINAL_PARAMETERS ? "final " : "";
            StringBuilder out = new StringBuilder(64);
            out.append("for(");
            out.append(finalString);
            out.append(contentType.getCanonicalText());
            out.append(' ');
            out.append(contentVariableName);
            out.append(": ");
            out.append(collection.getText());
            out.append(')');
            PsiType iteratorType = iterator.getType();
            PsiType iteratorContentType = WhileCanBeForeachFix.getContentType(iteratorType, manager);
            if (iteratorContentType != null && !TypeConversionUtil.isAssignable((PsiType)iteratorContentType, (PsiType)contentType)) {
                String typeText = iteratorContentType.getCanonicalText();
                contentVariableName = '(' + typeText + ')' + contentVariableName;
            }
            WhileCanBeForeachFix.replaceIteratorNext((PsiElement)body, contentVariableName, (PsiVariable)iterator, contentType, (PsiElement)statementToSkip, out);
            Query query = ReferencesSearch.search((PsiElement)iterator, (SearchScope)iterator.getUseScope());
            boolean deleteIterator = true;
            for (PsiReference usage : query) {
                PsiElement element = usage.getElement();
                if (PsiTreeUtil.isAncestor((PsiElement)whileStatement, (PsiElement)element, (boolean)true)) continue;
                PsiAssignmentExpression assignment = (PsiAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiAssignmentExpression.class);
                if (assignment == null) {
                    deleteIterator = false;
                    break;
                }
                PsiExpression expression = assignment.getRExpression();
                initializer.delete();
                iterator.setInitializer(expression);
                PsiElement statement = assignment.getParent();
                PsiElement lastChild = statement.getLastChild();
                if (lastChild instanceof PsiComment) {
                    iterator.add(lastChild);
                }
                statement.replace((PsiElement)iterator);
                break;
            }
            if (deleteIterator) {
                iterator.delete();
            }
            String result = out.toString();
            WhileCanBeForeachFix.replaceStatementAndShortenClassNames((PsiStatement)whileStatement, result);
        }

        @Nullable
        private static PsiType getContentType(PsiType type, PsiManager manager) {
            if (!(type instanceof PsiClassType)) {
                return null;
            }
            PsiClassType classType = (PsiClassType)type;
            PsiType[] parameters = classType.getParameters();
            if (parameters.length == 1) {
                PsiType parameterType = parameters[0];
                if (parameterType instanceof PsiCapturedWildcardType) {
                    PsiCapturedWildcardType wildcardType = (PsiCapturedWildcardType)parameterType;
                    PsiType bound = wildcardType.getUpperBound();
                    if (bound != null) {
                        return bound;
                    }
                } else if (parameterType != null) {
                    return parameterType;
                }
            }
            GlobalSearchScope scope = type.getResolveScope();
            return PsiType.getJavaLangObject((PsiManager)manager, (GlobalSearchScope)scope);
        }

        private static void replaceIteratorNext(@NotNull PsiElement element, String contentVariableName, PsiVariable iterator, PsiType contentType, PsiElement childToSkip, StringBuilder out) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/jdk15/WhileCanBeForeachInspection$WhileCanBeForeachFix.replaceIteratorNext must not be null");
            }
            if (WhileCanBeForeachFix.isIteratorNext(element, iterator, contentType)) {
                out.append(contentVariableName);
            } else {
                PsiElement[] children = element.getChildren();
                if (children.length == 0) {
                    out.append(element.getText());
                } else {
                    boolean skippingWhiteSpace = false;
                    for (PsiElement child : children) {
                        if (child.equals(childToSkip)) {
                            skippingWhiteSpace = true;
                            continue;
                        }
                        if (child instanceof PsiWhiteSpace && skippingWhiteSpace) continue;
                        skippingWhiteSpace = false;
                        WhileCanBeForeachFix.replaceIteratorNext(child, contentVariableName, iterator, contentType, childToSkip, out);
                    }
                }
            }
        }

        private static boolean isIteratorNextDeclaration(PsiStatement statement, PsiVariable iterator, PsiType contentType) {
            if (!(statement instanceof PsiDeclarationStatement)) {
                return false;
            }
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement;
            PsiElement[] elements = declarationStatement.getDeclaredElements();
            if (elements.length != 1) {
                return false;
            }
            if (!(elements[0] instanceof PsiLocalVariable)) {
                return false;
            }
            PsiLocalVariable variable = (PsiLocalVariable)elements[0];
            if (!variable.equals(iterator)) {
                return false;
            }
            PsiExpression initializer = variable.getInitializer();
            return WhileCanBeForeachFix.isIteratorNext((PsiElement)initializer, iterator, contentType);
        }

        private static boolean isIteratorNext(PsiElement element, PsiVariable iterator, PsiType contentType) {
            if (element == null) {
                return false;
            }
            if (element instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression castExpression = (PsiTypeCastExpression)element;
                PsiType type = castExpression.getType();
                if (type == null) {
                    return false;
                }
                if (!type.equals(contentType)) {
                    return false;
                }
                PsiExpression operand = castExpression.getOperand();
                return WhileCanBeForeachFix.isIteratorNext((PsiElement)operand, iterator, contentType);
            }
            if (!(element instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)element;
            PsiExpressionList argumentList = callExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 0) {
                return false;
            }
            PsiReferenceExpression reference = callExpression.getMethodExpression();
            String referenceName = reference.getReferenceName();
            if (!"next".equals(referenceName)) {
                return false;
            }
            PsiExpression expression = reference.getQualifierExpression();
            if (!(expression instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
            PsiElement target = referenceExpression.resolve();
            return iterator.equals(target);
        }

        private static String createNewVariableName(@NotNull PsiWhileStatement scope, PsiType type, String containerName) {
            String baseName;
            if (scope == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/jdk15/WhileCanBeForeachInspection$WhileCanBeForeachFix.createNewVariableName must not be null");
            }
            Project project = scope.getProject();
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            if (containerName != null) {
                baseName = StringUtils.createSingularFromName(containerName);
            } else {
                SuggestedNameInfo suggestions = codeStyleManager.suggestVariableName(VariableKind.LOCAL_VARIABLE, null, null, type);
                String[] names = suggestions.names;
                baseName = names != null && names.length > 0 ? names[0] : "value";
            }
            if (baseName == null || baseName.length() == 0) {
                baseName = "value";
            }
            return codeStyleManager.suggestUniqueVariableName(baseName, (PsiElement)scope, true);
        }

        @Nullable
        private static PsiStatement getFirstStatement(@NotNull PsiStatement body) {
            if (body == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/jdk15/WhileCanBeForeachInspection$WhileCanBeForeachFix.getFirstStatement must not be null");
            }
            if (body instanceof PsiBlockStatement) {
                PsiBlockStatement block = (PsiBlockStatement)body;
                PsiCodeBlock codeBlock = block.getCodeBlock();
                PsiStatement[] statements = codeBlock.getStatements();
                return statements.length > 0 ? statements[0] : null;
            }
            return body;
        }
    }
}

