/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.TestUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefusedBequestInspection
extends BaseInspection {
    public boolean ignoreEmptySuperMethods = false;

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("refused.bequest.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/inheritance/RefusedBequestInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("refused.bequest.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/inheritance/RefusedBequestInspection.buildErrorString must not return null");
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel("<html>" + InspectionGadgetsBundle.message("reqused.bequest.ignore.empty.super.methods.option", new Object[0]) + "</html>", (InspectionProfileEntry)this, "ignoreEmptySuperMethods");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new RefusedBequestVisitor();
    }

    private static class SuperCallVisitor
    extends JavaRecursiveElementVisitor {
        private final PsiMethod methodToSearchFor;
        private boolean hasSuperCall = false;

        SuperCallVisitor(PsiMethod methodToSearchFor) {
            this.methodToSearchFor = methodToSearchFor;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/inheritance/RefusedBequestInspection$SuperCallVisitor.visitElement must not be null");
            }
            if (!this.hasSuperCall) {
                super.visitElement(element);
            }
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/inheritance/RefusedBequestInspection$SuperCallVisitor.visitMethodCallExpression must not be null");
            }
            if (this.hasSuperCall) {
                return;
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            String text = qualifier.getText();
            if (!"super".equals(text)) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            if (method.equals(this.methodToSearchFor)) {
                this.hasSuperCall = true;
            }
        }

        public boolean hasSuperCall() {
            return this.hasSuperCall;
        }
    }

    private class RefusedBequestVisitor
    extends BaseInspectionVisitor {
        private RefusedBequestVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            PsiMethod navigationElement;
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/inheritance/RefusedBequestInspection$RefusedBequestVisitor.visitMethod must not be null");
            }
            PsiCodeBlock body = method.getBody();
            if (body == null) {
                return;
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            PsiMethod leastConcreteSuperMethod = this.getLeastConcreteSuperMethod(method);
            if (leastConcreteSuperMethod == null) {
                return;
            }
            PsiClass containingClass = leastConcreteSuperMethod.getContainingClass();
            if (containingClass == null) {
                return;
            }
            String className = containingClass.getQualifiedName();
            if ("java.lang.Object".equals(className)) {
                return;
            }
            if (RefusedBequestInspection.this.ignoreEmptySuperMethods && MethodUtils.isEmpty(navigationElement = (PsiMethod)leastConcreteSuperMethod.getNavigationElement())) {
                return;
            }
            if (TestUtils.isJUnit4BeforeOrAfterMethod(method)) {
                return;
            }
            if (this.containsSuperCall((PsiElement)body, leastConcreteSuperMethod)) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        @Nullable
        private PsiMethod getLeastConcreteSuperMethod(PsiMethod method) {
            PsiMethod[] superMethods;
            PsiMethod leastConcreteSuperMethod = null;
            for (PsiMethod superMethod : superMethods = method.findSuperMethods(true)) {
                PsiClass containingClass = superMethod.getContainingClass();
                if (containingClass == null || superMethod.hasModifierProperty("abstract") || containingClass.isInterface()) continue;
                leastConcreteSuperMethod = superMethod;
                return leastConcreteSuperMethod;
            }
            return leastConcreteSuperMethod;
        }

        private boolean containsSuperCall(@NotNull PsiElement context, @NotNull PsiMethod method) {
            if (context == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/inheritance/RefusedBequestInspection$RefusedBequestVisitor.containsSuperCall must not be null");
            }
            if (method == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/inheritance/RefusedBequestInspection$RefusedBequestVisitor.containsSuperCall must not be null");
            }
            SuperCallVisitor visitor = new SuperCallVisitor(method);
            context.accept((PsiElementVisitor)visitor);
            return visitor.hasSuperCall();
        }
    }
}

