/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.global;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefField;
import com.intellij.codeInspection.reference.RefGraphAnnotator;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BooleanFieldAlwaysNegatedInspection
extends BaseGlobalInspection {
    private static final Key<Boolean> ALWAYS_INVERTED = Key.create((String)"ALWAYS_INVERTED_FIELD");

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("boolean.field.always.negated.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/global/BooleanFieldAlwaysNegatedInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.CLASSLAYOUT_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/global/BooleanFieldAlwaysNegatedInspection.getGroupDisplayName must not return null");
        }
        return string;
    }

    @Nullable
    public RefGraphAnnotator getAnnotator(RefManager refManager) {
        return new BooleanInvertedAnnotator();
    }

    public CommonProblemDescriptor[] checkElement(RefEntity refEntity, AnalysisScope scope, InspectionManager manager, GlobalInspectionContext globalContext) {
        if (!(refEntity instanceof RefField)) {
            return null;
        }
        RefField refField = (RefField)refEntity;
        if (!refField.isReferenced()) {
            return null;
        }
        Boolean alwaysInverted = (Boolean)refField.getUserData(ALWAYS_INVERTED);
        if (alwaysInverted == null || !alwaysInverted.booleanValue()) {
            return null;
        }
        return new ProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)refField.getElement(), InspectionGadgetsBundle.message("boolean.field.always.negated.problem.descriptor", new Object[0]), false, (LocalQuickFix[])null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING)};
    }

    protected boolean queryExternalUsagesRequests(RefManager manager, final GlobalJavaInspectionContext context, final ProblemDescriptionsProcessor descriptionsProcessor) {
        manager.iterate((RefVisitor)new RefJavaVisitor(){

            public void visitField(final RefField refField) {
                if (descriptionsProcessor.getDescriptions((RefEntity)refField) != null) {
                    context.enqueueFieldUsagesProcessor(refField, new GlobalJavaInspectionContext.UsagesProcessor(){

                        public boolean process(PsiReference psiReference) {
                            PsiElement psiReferenceExpression = psiReference.getElement();
                            if (psiReferenceExpression instanceof PsiReferenceExpression && !BooleanFieldAlwaysNegatedInspection.isInvertedFieldRead((PsiReferenceExpression)psiReferenceExpression)) {
                                descriptionsProcessor.ignoreElement((RefEntity)refField);
                            }
                            return false;
                        }
                    });
                }
            }
        });
        return false;
    }

    private static boolean isInvertedFieldRead(PsiReferenceExpression referenceExpression) {
        PsiJavaToken sign;
        IElementType tokenType;
        PsiPrefixExpression prefixExpression = (PsiPrefixExpression)PsiTreeUtil.getParentOfType((PsiElement)referenceExpression, PsiPrefixExpression.class);
        if (prefixExpression != null && (tokenType = (sign = prefixExpression.getOperationSign()).getTokenType()).equals(JavaTokenType.EXCL)) {
            return true;
        }
        return BooleanFieldAlwaysNegatedInspection.isRead((PsiElement)referenceExpression);
    }

    private static boolean isRead(PsiElement element) {
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiAssignmentExpression)) {
            return true;
        }
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
        PsiExpression rhs = assignmentExpression.getRExpression();
        return element.equals(rhs);
    }

    private static class BooleanInvertedAnnotator
    extends RefGraphAnnotator {
        private BooleanInvertedAnnotator() {
        }

        public void onInitialize(RefElement refElement) {
            if (!(refElement instanceof RefField)) {
                return;
            }
            PsiElement element = refElement.getElement();
            if (!(element instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)element;
            if (!field.getType().equals(PsiType.BOOLEAN)) {
                return;
            }
            refElement.putUserData(ALWAYS_INVERTED, (Object)Boolean.TRUE);
        }

        public void onMarkReferenced(RefElement refWhat, RefElement refFrom, boolean referencedFromClassInitializer) {
            PsiElement element = refFrom.getElement();
            if (!(refWhat instanceof RefField)) {
                return;
            }
            final RefField refField = (RefField)refWhat;
            PsiField psiElement = refField.getElement();
            if (!(psiElement instanceof PsiField)) {
                return;
            }
            final PsiField field = psiElement;
            PsiType type = field.getType();
            if (!PsiType.BOOLEAN.equals(type)) {
                return;
            }
            element.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

                public void visitReferenceExpression(PsiReferenceExpression referenceExpression) {
                    super.visitReferenceExpression(referenceExpression);
                    if (referenceExpression.isReferenceTo((PsiElement)field)) {
                        if (BooleanFieldAlwaysNegatedInspection.isInvertedFieldRead(referenceExpression)) {
                            return;
                        }
                        refField.putUserData(ALWAYS_INVERTED, (Object)Boolean.FALSE);
                    }
                }
            });
        }
    }
}

