/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierList;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.FinalUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MakeFieldStaticFinalFix
extends InspectionGadgetsFix {
    private final String fieldName;

    private MakeFieldStaticFinalFix(String fieldName) {
        this.fieldName = fieldName;
    }

    @NotNull
    public static InspectionGadgetsFix buildFixUnconditional(@NotNull PsiField field) {
        if (field == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/fixes/MakeFieldStaticFinalFix.buildFixUnconditional must not be null");
        }
        MakeFieldStaticFinalFix makeFieldStaticFinalFix = new MakeFieldStaticFinalFix(field.getName());
        if (makeFieldStaticFinalFix == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/fixes/MakeFieldStaticFinalFix.buildFixUnconditional must not return null");
        }
        return makeFieldStaticFinalFix;
    }

    @Nullable
    public static InspectionGadgetsFix buildFix(PsiField field) {
        PsiExpression initializer = field.getInitializer();
        if (initializer == null) {
            return null;
        }
        if (!FinalUtils.canFieldBeFinal(field)) {
            return null;
        }
        return new MakeFieldStaticFinalFix(field.getName());
    }

    @NotNull
    public String getName() {
        String string = InspectionGadgetsBundle.message("make.static.final.quickfix", this.fieldName);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/fixes/MakeFieldStaticFinalFix.getName must not return null");
        }
        return string;
    }

    @Override
    protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
        PsiElement element = descriptor.getPsiElement();
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiField)) {
            return;
        }
        PsiField field = (PsiField)parent;
        PsiModifierList modifierList = field.getModifierList();
        if (modifierList == null) {
            return;
        }
        modifierList.setModifierProperty("final", true);
        modifierList.setModifierProperty("static", true);
    }
}

