/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.Modifier;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ChangeModifierFix
extends InspectionGadgetsFix {
    @Modifier
    private final String modifierText;

    public ChangeModifierFix(@NonNls @Modifier String modifierText) {
        this.modifierText = modifierText;
    }

    @NotNull
    public String getName() {
        String string = InspectionGadgetsBundle.message("change.modifier.quickfix", this.modifierText);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/fixes/ChangeModifierFix.getName must not return null");
        }
        return string;
    }

    @Override
    public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
        PsiElement element = descriptor.getPsiElement();
        PsiModifierListOwner modifierListOwner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)element, PsiModifierListOwner.class);
        if (modifierListOwner == null) {
            return;
        }
        PsiModifierList modifiers = modifierListOwner.getModifierList();
        if (modifiers == null) {
            return;
        }
        modifiers.setModifierProperty(this.modifierText, true);
    }
}

