/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TestUtils;
import com.siyeh.ig.ui.AddAction;
import com.siyeh.ig.ui.IGTable;
import com.siyeh.ig.ui.ListWrappingTableModel;
import com.siyeh.ig.ui.RemoveAction;
import com.siyeh.ig.ui.ToggleAction;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class BadExceptionDeclaredInspection
extends BaseInspection {
    public String exceptionsString = "java.lang.Throwable,java.lang.Exception,java.lang.Error,java.lang.RuntimeException,java.lang.NullPointerException,java.lang.ClassCastException,java.lang.ArrayIndexOutOfBoundsException";
    public boolean ignoreTestCases = false;
    final List<String> exceptionList = new ArrayList<String>(32);

    public BadExceptionDeclaredInspection() {
        BadExceptionDeclaredInspection.parseString(this.exceptionsString, this.exceptionList);
    }

    @NotNull
    public String getID() {
        if ("ProhibitedExceptionDeclared" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/errorhandling/BadExceptionDeclaredInspection.getID must not return null");
        }
        return "ProhibitedExceptionDeclared";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("bad.exception.declared.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/errorhandling/BadExceptionDeclaredInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("bad.exception.declared.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/errorhandling/BadExceptionDeclaredInspection.buildErrorString must not return null");
        }
        return string;
    }

    public void readSettings(Element element) throws InvalidDataException {
        super.readSettings(element);
        BadExceptionDeclaredInspection.parseString(this.exceptionsString, this.exceptionList);
    }

    public void writeSettings(Element element) throws WriteExternalException {
        this.exceptionsString = BadExceptionDeclaredInspection.formatString(this.exceptionList);
        super.writeSettings(element);
    }

    public JComponent createOptionsPanel() {
        Form form = new Form();
        return form.getContentPanel();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BadExceptionDeclaredVisitor();
    }

    private class Form {
        JPanel contentPanel;
        JButton addButton;
        JButton removeButton;
        JCheckBox ignoreTestCasesCheckBox;
        IGTable table;

        Form() {
            this.$$$setupUI$$$();
            this.addButton.setAction(new AddAction(this.table));
            this.removeButton.setAction(new RemoveAction(this.table));
            this.ignoreTestCasesCheckBox.setAction(new ToggleAction(InspectionGadgetsBundle.message("bad.exception.declared.ignore.exceptions.declared.in.junit.test.cases.option", new Object[0]), BadExceptionDeclaredInspection.this, "ignoreTestCases"));
            this.ignoreTestCasesCheckBox.setSelected(BadExceptionDeclaredInspection.this.ignoreTestCases);
        }

        private void createUIComponents() {
            this.table = new IGTable(new ListWrappingTableModel(BadExceptionDeclaredInspection.this.exceptionList, InspectionGadgetsBundle.message("exception.class.column.name", new Object[0])));
        }

        public JComponent getContentPanel() {
            return this.contentPanel;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JButton jButton;
            JButton jButton2;
            JCheckBox jCheckBox;
            JPanel jPanel;
            this.createUIComponents();
            this.contentPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(4, 4, 4, 4), 4, 4, false, false));
            this.ignoreTestCasesCheckBox = jCheckBox = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("com/siyeh/InspectionGadgetsBundle").getString("bad.exception.declared.ignore.exceptions.declared.in.junit.test.cases.option"));
            jPanel.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 2, 8, 0, 3, 0, null, null, null));
            this.addButton = jButton2 = new JButton();
            jButton2.setMargin(new Insets(3, 8, 3, 8));
            this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("com/siyeh/InspectionGadgetsBundle").getString("button.add"));
            jButton2.setIconTextGap(0);
            jButton2.setHorizontalAlignment(0);
            jPanel.add((Component)jButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 0, 0, null, null, null));
            this.removeButton = jButton = new JButton();
            jButton.setMargin(new Insets(3, 8, 3, 8));
            this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("com/siyeh/InspectionGadgetsBundle").getString("button.remove"));
            jButton.setIconTextGap(0);
            ((Component)jButton).setEnabled(true);
            jPanel.add((Component)jButton, new GridConstraints(1, 1, 1, 1, 0, 1, 0, 0, null, null, null));
            JScrollPane jScrollPane = new JScrollPane();
            jPanel.add((Component)jScrollPane, new GridConstraints(0, 0, 3, 1, 0, 3, 7, 3, null, null, null));
            IGTable iGTable = this.table;
            jScrollPane.setViewportView((Component)((Object)iGTable));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.contentPanel;
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }

    private class BadExceptionDeclaredVisitor
    extends BaseInspectionVisitor {
        private final Set<String> exceptionSet;

        private BadExceptionDeclaredVisitor() {
            this.exceptionSet = new HashSet<String>(BadExceptionDeclaredInspection.this.exceptionList);
        }

        public void visitMethod(@NotNull PsiMethod method) {
            PsiJavaCodeReferenceElement[] references;
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/errorhandling/BadExceptionDeclaredInspection$BadExceptionDeclaredVisitor.visitMethod must not be null");
            }
            super.visitMethod(method);
            if (BadExceptionDeclaredInspection.this.ignoreTestCases && TestUtils.isJUnitTestMethod(method)) {
                return;
            }
            PsiReferenceList throwsList = method.getThrowsList();
            for (PsiJavaCodeReferenceElement reference : references = throwsList.getReferenceElements()) {
                PsiClass thrownClass;
                String qualifiedName;
                PsiElement element = reference.resolve();
                if (!(element instanceof PsiClass) || (qualifiedName = (thrownClass = (PsiClass)element).getQualifiedName()) == null || !this.exceptionSet.contains(qualifiedName)) continue;
                this.registerError((PsiElement)reference, new Object[0]);
            }
        }
    }
}

