/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.encapsulation;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class ReturnOfDateFieldInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("return.date.calendar.field.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/encapsulation/ReturnOfDateFieldInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String type = (String)infos[0];
        String string = InspectionGadgetsBundle.message("return.date.calendar.field.problem.descriptor", type);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/encapsulation/ReturnOfDateFieldInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ReturnOfDateFieldVisitor();
    }

    private static class ReturnOfDateFieldVisitor
    extends BaseInspectionVisitor {
        private ReturnOfDateFieldVisitor() {
        }

        public void visitReturnStatement(@NotNull PsiReturnStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/encapsulation/ReturnOfDateFieldInspection$ReturnOfDateFieldVisitor.visitReturnStatement must not be null");
            }
            super.visitReturnStatement(statement);
            PsiExpression returnValue = statement.getReturnValue();
            if (!(returnValue instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression fieldReference = (PsiReferenceExpression)returnValue;
            PsiElement element = fieldReference.resolve();
            if (!(element instanceof PsiField)) {
                return;
            }
            String type = TypeUtils.expressionHasTypeOrSubtype(returnValue, "java.util.Date", "java.util.Calendar");
            if (type == null) {
                return;
            }
            this.registerError((PsiElement)returnValue, type);
        }
    }
}

