/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IfMayBeConditionalInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("if.may.be.conditional.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/IfMayBeConditionalInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("if.may.be.conditional.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/IfMayBeConditionalInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new IfMayBeConditionalFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new IfMayBeConditionalVisitor();
    }

    private static class IfMayBeConditionalVisitor
    extends BaseInspectionVisitor {
        private IfMayBeConditionalVisitor() {
        }

        public void visitIfStatement(PsiIfStatement statement) {
            super.visitIfStatement(statement);
            PsiStatement thenBranch = statement.getThenBranch();
            PsiStatement elseBranch = statement.getElseBranch();
            PsiStatement thenStatement = ControlFlowUtils.stripBraces(thenBranch);
            if (thenStatement == null) {
                return;
            }
            PsiStatement elseStatement = ControlFlowUtils.stripBraces(elseBranch);
            if (elseStatement == null) {
                return;
            }
            if (thenStatement instanceof PsiReturnStatement) {
                if (!(elseStatement instanceof PsiReturnStatement)) {
                    return;
                }
                this.registerStatementError((PsiStatement)statement, new Object[0]);
            } else if (thenStatement instanceof PsiExpressionStatement) {
                if (!(elseStatement instanceof PsiExpressionStatement)) {
                    return;
                }
                PsiExpressionStatement thenExpressionStatement = (PsiExpressionStatement)thenStatement;
                PsiExpression thenExpression = thenExpressionStatement.getExpression();
                if (!(thenExpression instanceof PsiAssignmentExpression)) {
                    return;
                }
                PsiAssignmentExpression thenAssignmentExpression = (PsiAssignmentExpression)thenExpression;
                PsiExpressionStatement elseExpressionStatement = (PsiExpressionStatement)elseStatement;
                PsiExpression elseExpression = elseExpressionStatement.getExpression();
                if (!(elseExpression instanceof PsiAssignmentExpression)) {
                    return;
                }
                PsiAssignmentExpression elseAssignmentExpression = (PsiAssignmentExpression)elseExpression;
                if (!thenAssignmentExpression.getOperationTokenType().equals(elseAssignmentExpression.getOperationTokenType())) {
                    return;
                }
                PsiVariable thenVariable = IfMayBeConditionalVisitor.getAssignmentTarget(thenAssignmentExpression);
                if (thenVariable == null) {
                    return;
                }
                PsiVariable elseVariable = IfMayBeConditionalVisitor.getAssignmentTarget(elseAssignmentExpression);
                if (elseVariable == null) {
                    return;
                }
                if (thenVariable != elseVariable) {
                    return;
                }
                this.registerStatementError((PsiStatement)statement, new Object[0]);
            }
        }

        private static PsiVariable getAssignmentTarget(PsiAssignmentExpression assignmentExpression) {
            PsiExpression thenLhs = assignmentExpression.getLExpression();
            if (!(thenLhs instanceof PsiReferenceExpression)) {
                return null;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)thenLhs;
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiVariable)) {
                return null;
            }
            return (PsiVariable)target;
        }
    }

    private static class IfMayBeConditionalFix
    extends InspectionGadgetsFix {
        private IfMayBeConditionalFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("if.may.be.conditional.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/IfMayBeConditionalInspection$IfMayBeConditionalFix.getName must not return null");
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            PsiIfStatement ifStatement = (PsiIfStatement)element.getParent();
            PsiStatement thenBranch = ifStatement.getThenBranch();
            PsiStatement thenStatement = ControlFlowUtils.stripBraces(thenBranch);
            PsiStatement elseBranch = ifStatement.getElseBranch();
            PsiStatement elseStatement = ControlFlowUtils.stripBraces(elseBranch);
            PsiExpression condition = ifStatement.getCondition();
            StringBuilder replacementText = new StringBuilder();
            if (thenStatement instanceof PsiReturnStatement) {
                PsiReturnStatement elseReturn = (PsiReturnStatement)elseStatement;
                PsiReturnStatement thenReturn = (PsiReturnStatement)thenStatement;
                replacementText.append("return ");
                IfMayBeConditionalFix.appendExpressionText(condition, replacementText);
                replacementText.append('?');
                PsiExpression thenReturnValue = thenReturn.getReturnValue();
                IfMayBeConditionalFix.appendExpressionText(thenReturnValue, replacementText);
                replacementText.append(':');
                if (elseReturn != null) {
                    PsiExpression elseReturnValue = elseReturn.getReturnValue();
                    IfMayBeConditionalFix.appendExpressionText(elseReturnValue, replacementText);
                }
                replacementText.append(';');
            } else if (thenStatement instanceof PsiExpressionStatement) {
                PsiExpression elseExpression;
                PsiExpressionStatement thenExpressionStatement = (PsiExpressionStatement)thenStatement;
                PsiExpression thenExpression = thenExpressionStatement.getExpression();
                if (!(thenExpression instanceof PsiAssignmentExpression)) {
                    return;
                }
                PsiAssignmentExpression thenAssignmentExpression = (PsiAssignmentExpression)thenExpression;
                PsiExpression lhs = thenAssignmentExpression.getLExpression();
                IfMayBeConditionalFix.appendExpressionText(lhs, replacementText);
                PsiJavaToken token = thenAssignmentExpression.getOperationSign();
                replacementText.append(token.getText());
                IfMayBeConditionalFix.appendExpressionText(condition, replacementText);
                replacementText.append('?');
                PsiExpression thenRhs = thenAssignmentExpression.getRExpression();
                IfMayBeConditionalFix.appendExpressionText(thenRhs, replacementText);
                replacementText.append(':');
                PsiExpressionStatement elseExpressionStatement = (PsiExpressionStatement)elseStatement;
                if (elseExpressionStatement != null && (elseExpression = elseExpressionStatement.getExpression()) instanceof PsiAssignmentExpression) {
                    PsiAssignmentExpression elseAssignmentExpression = (PsiAssignmentExpression)elseExpression;
                    PsiExpression elseRhs = elseAssignmentExpression.getRExpression();
                    IfMayBeConditionalFix.appendExpressionText(elseRhs, replacementText);
                }
                replacementText.append(';');
            }
            IfMayBeConditionalFix.replaceStatement((PsiStatement)ifStatement, replacementText.toString());
        }

        private static void appendExpressionText(@Nullable PsiExpression expression, StringBuilder out) {
            PsiExpression strippedExpression = ParenthesesUtils.stripParentheses(expression);
            if (strippedExpression == null) {
                return;
            }
            String expressionText = strippedExpression.getText();
            if (ParenthesesUtils.getPrecedence(expression) > 15) {
                out.append('(');
                out.append(expressionText);
                out.append(')');
            } else {
                out.append(expressionText);
            }
        }
    }
}

