/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classmetrics;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.classmetrics.ClassMetricInspection;
import com.siyeh.ig.fixes.MoveAnonymousToInnerClassFix;
import org.jetbrains.annotations.NotNull;

public class AnonymousClassMethodCountInspection
extends ClassMetricInspection {
    private static final int DEFAULT_METHOD_COUNT_LIMIT = 1;

    @NotNull
    public String getID() {
        if ("AnonymousInnerClassWithTooManyMethods" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/classmetrics/AnonymousClassMethodCountInspection.getID must not return null");
        }
        return "AnonymousInnerClassWithTooManyMethods";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("anonymous.inner.class.with.too.many.methods.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/classmetrics/AnonymousClassMethodCountInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    protected int getDefaultLimit() {
        return 1;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionGadgetsBundle.message("method.count.limit.option", new Object[0]);
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new MoveAnonymousToInnerClassFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer count = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("anonymous.inner.class.with.too.many.methods.problem.descriptor", count);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/classmetrics/AnonymousClassMethodCountInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AnonymousClassMethodCountVisitor();
    }

    private class AnonymousClassMethodCountVisitor
    extends BaseInspectionVisitor {
        private AnonymousClassMethodCountVisitor() {
        }

        public void visitClass(@NotNull PsiClass psiClass) {
            if (psiClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/classmetrics/AnonymousClassMethodCountInspection$AnonymousClassMethodCountVisitor.visitClass must not be null");
            }
        }

        public void visitAnonymousClass(@NotNull PsiAnonymousClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/classmetrics/AnonymousClassMethodCountInspection$AnonymousClassMethodCountVisitor.visitAnonymousClass must not be null");
            }
            if (aClass instanceof PsiEnumConstantInitializer) {
                return;
            }
            int totalMethodCount = this.calculateTotalMethodCount((PsiClass)aClass);
            if (totalMethodCount <= AnonymousClassMethodCountInspection.this.getLimit()) {
                return;
            }
            this.registerClassError((PsiClass)aClass, totalMethodCount);
        }

        private int calculateTotalMethodCount(PsiClass aClass) {
            PsiMethod[] methods = aClass.getMethods();
            int totalCount = 0;
            for (PsiMethod method : methods) {
                if (method.isConstructor()) continue;
                ++totalCount;
            }
            return totalCount;
        }
    }
}

