/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaFile;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassNameDiffersFromFileNameInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("class.name.differs.from.file.name.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/classlayout/ClassNameDiffersFromFileNameInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("class.name.differs.from.file.name.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/classlayout/ClassNameDiffersFromFileNameInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiClass[] classes;
        PsiJavaFile file = (PsiJavaFile)infos[0];
        String fileName = file.getName();
        int prefixIndex = fileName.indexOf(46);
        String filenameWithoutPrefix = fileName.substring(0, prefixIndex);
        for (PsiClass psiClass : classes = file.getClasses()) {
            String className = psiClass.getName();
            if (!filenameWithoutPrefix.equals(className)) continue;
            return null;
        }
        return new RenameFix(filenameWithoutPrefix);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ClassNameDiffersFromFileNameVisitor();
    }

    private static class ClassNameDiffersFromFileNameVisitor
    extends BaseInspectionVisitor {
        private ClassNameDiffersFromFileNameVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/classlayout/ClassNameDiffersFromFileNameInspection$ClassNameDiffersFromFileNameVisitor.visitClass must not be null");
            }
            if (JspPsiUtil.isInJspFile((PsiElement)aClass)) {
                return;
            }
            PsiElement parent = aClass.getParent();
            if (!(parent instanceof PsiJavaFile)) {
                return;
            }
            PsiJavaFile file = (PsiJavaFile)parent;
            String className = aClass.getName();
            if (className == null) {
                return;
            }
            String fileName = file.getName();
            int prefixIndex = fileName.indexOf(46);
            if (prefixIndex < 0) {
                return;
            }
            String filenameWithoutPrefix = fileName.substring(0, prefixIndex);
            if (className.equals(filenameWithoutPrefix)) {
                return;
            }
            this.registerClassError(aClass, file);
        }
    }
}

