/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

public class NonShortCircuitBooleanInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("NonShortCircuitBooleanExpression" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/NonShortCircuitBooleanInspection.getID must not return null");
        }
        return "NonShortCircuitBooleanExpression";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("non.short.circuit.boolean.expression.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/NonShortCircuitBooleanInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("non.short.circuit.boolean.expression.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/NonShortCircuitBooleanInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new NonShortCircuitBooleanFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NonShortCircuitBooleanVisitor();
    }

    private static class NonShortCircuitBooleanVisitor
    extends BaseInspectionVisitor {
        private NonShortCircuitBooleanVisitor() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/NonShortCircuitBooleanInspection$NonShortCircuitBooleanVisitor.visitBinaryExpression must not be null");
            }
            super.visitBinaryExpression(expression);
            if (expression.getROperand() == null) {
                return;
            }
            PsiJavaToken sign = expression.getOperationSign();
            IElementType tokenType = sign.getTokenType();
            if (!tokenType.equals(JavaTokenType.AND) && !tokenType.equals(JavaTokenType.OR)) {
                return;
            }
            PsiType type = expression.getType();
            if (type == null) {
                return;
            }
            if (!type.equals(PsiType.BOOLEAN)) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }
    }

    private static class NonShortCircuitBooleanFix
    extends InspectionGadgetsFix {
        private NonShortCircuitBooleanFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("non.short.circuit.boolean.expression.replace.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/NonShortCircuitBooleanInspection$NonShortCircuitBooleanFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiBinaryExpression expression = (PsiBinaryExpression)descriptor.getPsiElement();
            PsiExpression lhs = expression.getLOperand();
            PsiExpression rhs = expression.getROperand();
            PsiJavaToken operationSign = expression.getOperationSign();
            IElementType tokenType = operationSign.getTokenType();
            assert (rhs != null);
            String newExpression = lhs.getText() + NonShortCircuitBooleanFix.getShortCircuitOperand(tokenType) + rhs.getText();
            NonShortCircuitBooleanFix.replaceExpression((PsiExpression)expression, newExpression);
        }

        private static String getShortCircuitOperand(IElementType tokenType) {
            if (tokenType.equals(JavaTokenType.AND)) {
                return "&&";
            }
            return "||";
        }
    }
}

