/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.InstanceOfUtils;
import org.jetbrains.annotations.NotNull;

public class CastConflictsWithInstanceofInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("cast.conflicts.with.instanceof.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/CastConflictsWithInstanceofInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("cast.conflicts.with.instanceof.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/CastConflictsWithInstanceofInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        PsiType castExpressionType = (PsiType)infos[0];
        PsiInstanceOfExpression conflictingInstanceof = (PsiInstanceOfExpression)infos[1];
        PsiTypeElement typeElement = conflictingInstanceof.getCheckType();
        InspectionGadgetsFix[] inspectionGadgetsFixArray = new InspectionGadgetsFix[]{new ReplaceCastFix(typeElement, castExpressionType), new ReplaceInstanceofFix(typeElement, castExpressionType)};
        if (inspectionGadgetsFixArray == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/CastConflictsWithInstanceofInspection.buildFixes must not return null");
        }
        return inspectionGadgetsFixArray;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CastConflictsWithInstanceofVisitor();
    }

    private static class ReplaceInstanceofFix
    extends ReplaceFix {
        public ReplaceInstanceofFix(PsiTypeElement instanceofTypeElement, PsiType castExpressionType) {
            super(instanceofTypeElement, castExpressionType);
        }

        @Override
        protected PsiElement replace(PsiTypeElement castTypeElement, PsiTypeElement instanceofTypeElement, Project project) {
            return instanceofTypeElement.replace((PsiElement)castTypeElement);
        }

        @NotNull
        public String getName() {
            String string = "Replace instanceof '" + this.myInstanceofTypeElement.getType().getPresentableText() + "' with '" + this.myCastType.getPresentableText() + '\'';
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/CastConflictsWithInstanceofInspection$ReplaceInstanceofFix.getName must not return null");
            }
            return string;
        }
    }

    private static class ReplaceCastFix
    extends ReplaceFix {
        public ReplaceCastFix(PsiTypeElement instanceofTypeElement, PsiType castType) {
            super(instanceofTypeElement, castType);
        }

        @Override
        protected PsiElement replace(PsiTypeElement castTypeElement, PsiTypeElement instanceofTypeElement, Project project) {
            return castTypeElement.replace((PsiElement)instanceofTypeElement);
        }

        @NotNull
        public String getName() {
            String string = "Replace cast to '" + this.myCastType.getPresentableText() + "' with '" + this.myInstanceofTypeElement.getType().getPresentableText() + '\'';
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/bugs/CastConflictsWithInstanceofInspection$ReplaceCastFix.getName must not return null");
            }
            return string;
        }
    }

    private static abstract class ReplaceFix
    extends InspectionGadgetsFix {
        protected final PsiTypeElement myInstanceofTypeElement;
        protected final PsiType myCastType;

        protected ReplaceFix(@NotNull PsiTypeElement instanceofTypeElement, @NotNull PsiType castType) {
            if (instanceofTypeElement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/CastConflictsWithInstanceofInspection$ReplaceFix.<init> must not be null");
            }
            if (castType == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/bugs/CastConflictsWithInstanceofInspection$ReplaceFix.<init> must not be null");
            }
            this.myInstanceofTypeElement = instanceofTypeElement;
            this.myCastType = castType;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)descriptor.getPsiElement();
            PsiTypeElement castTypeElement = typeCastExpression.getCastType();
            if (castTypeElement == null) {
                return;
            }
            PsiElement newElement = this.replace(castTypeElement, this.myInstanceofTypeElement, project);
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            codeStyleManager.shortenClassReferences(newElement);
        }

        protected abstract PsiElement replace(PsiTypeElement var1, PsiTypeElement var2, Project var3);
    }

    private static class CastConflictsWithInstanceofVisitor
    extends BaseInspectionVisitor {
        private CastConflictsWithInstanceofVisitor() {
        }

        public void visitTypeCastExpression(@NotNull PsiTypeCastExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bugs/CastConflictsWithInstanceofInspection$CastConflictsWithInstanceofVisitor.visitTypeCastExpression must not be null");
            }
            super.visitTypeCastExpression(expression);
            PsiType castType = expression.getType();
            if (castType == null) {
                return;
            }
            PsiInstanceOfExpression conflictingInstanceof = InstanceOfUtils.getConflictingInstanceof(expression);
            if (conflictingInstanceof == null) {
                return;
            }
            this.registerError((PsiElement)expression, castType, conflictingInstanceof);
        }
    }
}

