/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bitwise;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class ShiftOutOfRangeInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("shift.operation.by.inappropriate.constant.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bitwise/ShiftOutOfRangeInspection.getDisplayName must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string;
        Integer value = (Integer)infos[0];
        if (value > 0) {
            string = InspectionGadgetsBundle.message("shift.operation.by.inappropriate.constant.problem.descriptor.too.large", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/bitwise/ShiftOutOfRangeInspection.buildErrorString must not return null");
            return string;
        }
        string = InspectionGadgetsBundle.message("shift.operation.by.inappropriate.constant.problem.descriptor.negative", new Object[0]);
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/siyeh/ig/bitwise/ShiftOutOfRangeInspection.buildErrorString must not return null");
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ShiftOutOfRange();
    }

    private static class ShiftOutOfRange
    extends BaseInspectionVisitor {
        private ShiftOutOfRange() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bitwise/ShiftOutOfRangeInspection$ShiftOutOfRange.visitBinaryExpression must not be null");
            }
            super.visitBinaryExpression(expression);
            if (expression.getROperand() == null) {
                return;
            }
            PsiJavaToken sign = expression.getOperationSign();
            IElementType tokenType = sign.getTokenType();
            if (!(tokenType.equals(JavaTokenType.LTLT) || tokenType.equals(JavaTokenType.GTGT) || tokenType.equals(JavaTokenType.GTGTGT))) {
                return;
            }
            PsiType expressionType = expression.getType();
            if (expressionType == null) {
                return;
            }
            PsiExpression rhs = expression.getROperand();
            if (rhs == null) {
                return;
            }
            if (!PsiUtil.isConstantExpression((PsiExpression)rhs)) {
                return;
            }
            Integer valueObject = (Integer)ConstantExpressionUtil.computeCastTo((PsiExpression)rhs, (PsiType)PsiType.INT);
            if (valueObject == null) {
                return;
            }
            int value = valueObject;
            if (expressionType.equals(PsiType.LONG) && (value < 0 || value > 63)) {
                this.registerError((PsiElement)sign, valueObject);
            }
            if (expressionType.equals(PsiType.INT) && (value < 0 || value > 31)) {
                this.registerError((PsiElement)sign, valueObject);
            }
        }
    }
}

