/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bitwise;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class IncompatibleMaskInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("IncompatibleBitwiseMaskOperation" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bitwise/IncompatibleMaskInspection.getID must not return null");
        }
        return "IncompatibleBitwiseMaskOperation";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("incompatible.mask.operation.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/bitwise/IncompatibleMaskInspection.getDisplayName must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string;
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)infos[0];
        PsiJavaToken operationSign = binaryExpression.getOperationSign();
        IElementType tokenType = operationSign.getTokenType();
        if (tokenType.equals(JavaTokenType.EQEQ)) {
            string = InspectionGadgetsBundle.message("incompatible.mask.operation.problem.descriptor.always.false", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/bitwise/IncompatibleMaskInspection.buildErrorString must not return null");
            return string;
        }
        string = InspectionGadgetsBundle.message("incompatible.mask.operation.problem.descriptor.always.true", new Object[0]);
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/siyeh/ig/bitwise/IncompatibleMaskInspection.buildErrorString must not return null");
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new IncompatibleMaskVisitor();
    }

    private static class IncompatibleMaskVisitor
    extends BaseInspectionVisitor {
        private IncompatibleMaskVisitor() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/bitwise/IncompatibleMaskInspection$IncompatibleMaskVisitor.visitBinaryExpression must not be null");
            }
            super.visitBinaryExpression(expression);
            PsiExpression rhs = expression.getROperand();
            if (!ComparisonUtils.isEqualityComparison(expression)) {
                return;
            }
            PsiType expressionType = expression.getType();
            if (expressionType == null) {
                return;
            }
            PsiExpression strippedRhs = ParenthesesUtils.stripParentheses(rhs);
            if (strippedRhs == null) {
                return;
            }
            PsiExpression lhs = expression.getLOperand();
            PsiExpression strippedLhs = ParenthesesUtils.stripParentheses(lhs);
            if (strippedLhs == null) {
                return;
            }
            if (IncompatibleMaskVisitor.isConstantMask(strippedLhs) && PsiUtil.isConstantExpression((PsiExpression)strippedRhs)) {
                if (IncompatibleMaskVisitor.isIncompatibleMask((PsiBinaryExpression)strippedLhs, strippedRhs)) {
                    this.registerError((PsiElement)expression, expression);
                }
            } else if (IncompatibleMaskVisitor.isConstantMask(strippedRhs) && PsiUtil.isConstantExpression((PsiExpression)strippedLhs) && IncompatibleMaskVisitor.isIncompatibleMask((PsiBinaryExpression)strippedRhs, strippedLhs)) {
                this.registerError((PsiElement)expression, expression);
            }
        }

        private static boolean isIncompatibleMask(PsiBinaryExpression maskExpression, PsiExpression constantExpression) {
            long constantMaskValue;
            PsiJavaToken sign = maskExpression.getOperationSign();
            IElementType tokenType = sign.getTokenType();
            Object constantValue = ConstantExpressionUtil.computeCastTo((PsiExpression)constantExpression, (PsiType)PsiType.LONG);
            if (constantValue == null) {
                return false;
            }
            long constantLongValue = (Long)constantValue;
            PsiExpression maskRhs = maskExpression.getROperand();
            PsiExpression maskLhs = maskExpression.getLOperand();
            if (PsiUtil.isConstantExpression((PsiExpression)maskRhs)) {
                Object rhsValue = ConstantExpressionUtil.computeCastTo((PsiExpression)maskRhs, (PsiType)PsiType.LONG);
                if (rhsValue == null) {
                    return false;
                }
                constantMaskValue = (Long)rhsValue;
            } else {
                Object lhsValue = ConstantExpressionUtil.computeCastTo((PsiExpression)maskLhs, (PsiType)PsiType.LONG);
                if (lhsValue == null) {
                    return false;
                }
                constantMaskValue = (Long)lhsValue;
            }
            if (tokenType.equals(JavaTokenType.OR) && (constantMaskValue | constantLongValue) != constantLongValue) {
                return true;
            }
            return tokenType.equals(JavaTokenType.AND) && (constantMaskValue | constantLongValue) != constantMaskValue;
        }

        private static boolean isConstantMask(PsiExpression expression) {
            if (expression == null) {
                return false;
            }
            if (!(expression instanceof PsiBinaryExpression)) {
                return false;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
            PsiJavaToken sign = binaryExpression.getOperationSign();
            IElementType tokenType = sign.getTokenType();
            if (!tokenType.equals(JavaTokenType.OR) && !tokenType.equals(JavaTokenType.AND)) {
                return false;
            }
            PsiExpression rhs = binaryExpression.getROperand();
            if (PsiUtil.isConstantExpression((PsiExpression)rhs)) {
                return true;
            }
            PsiExpression lhs = binaryExpression.getLOperand();
            return PsiUtil.isConstantExpression((PsiExpression)lhs);
        }
    }
}

