/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.assignment;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.ui.MultipleCheckboxOptionsPanel;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplaceAssignmentWithOperatorAssignmentInspection
extends BaseInspection {
    public boolean ignoreLazyOperators = true;
    public boolean ignoreObscureOperators = false;

    @NotNull
    public String getID() {
        if ("AssignmentReplaceableWithOperatorAssignment" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/assignment/ReplaceAssignmentWithOperatorAssignmentInspection.getID must not return null");
        }
        return "AssignmentReplaceableWithOperatorAssignment";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("assignment.replaceable.with.operator.assignment.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/assignment/ReplaceAssignmentWithOperatorAssignmentInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)infos[0];
        String string = InspectionGadgetsBundle.message("assignment.replaceable.with.operator.assignment.problem.descriptor", ReplaceAssignmentWithOperatorAssignmentInspection.calculateReplacementExpression(assignmentExpression));
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/assignment/ReplaceAssignmentWithOperatorAssignmentInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel(this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("assignment.replaceable.with.operator.assignment.ignore.conditional.operators.option", new Object[0]), "ignoreLazyOperators");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("assignment.replaceable.with.operator.assignment.ignore.obscure.operators.option", new Object[0]), "ignoreObscureOperators");
        return optionsPanel;
    }

    static String calculateReplacementExpression(PsiAssignmentExpression expression) {
        PsiExpression rhs = expression.getRExpression();
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)PsiUtil.deparenthesizeExpression((PsiExpression)rhs);
        PsiExpression lhs = expression.getLExpression();
        assert (binaryExpression != null);
        PsiJavaToken sign = binaryExpression.getOperationSign();
        PsiExpression rhsRhs = binaryExpression.getROperand();
        assert (rhsRhs != null);
        String signText = sign.getText();
        if ("&&".equals(signText)) {
            signText = "&";
        } else if ("||".equals(signText)) {
            signText = "|";
        }
        return lhs.getText() + ' ' + signText + "= " + rhsRhs.getText();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ReplaceAssignmentWithOperatorAssignmentFix((PsiAssignmentExpression)infos[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ReplaceAssignmentWithOperatorAssignmentVisitor();
    }

    private class ReplaceAssignmentWithOperatorAssignmentVisitor
    extends BaseInspectionVisitor {
        private ReplaceAssignmentWithOperatorAssignmentVisitor() {
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression assignment) {
            if (assignment == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/assignment/ReplaceAssignmentWithOperatorAssignmentInspection$ReplaceAssignmentWithOperatorAssignmentVisitor.visitAssignmentExpression must not be null");
            }
            super.visitAssignmentExpression(assignment);
            PsiJavaToken sign = assignment.getOperationSign();
            IElementType assignmentTokenType = sign.getTokenType();
            if (!assignmentTokenType.equals(JavaTokenType.EQ)) {
                return;
            }
            PsiExpression lhs = assignment.getLExpression();
            PsiExpression rhs = PsiUtil.deparenthesizeExpression((PsiExpression)assignment.getRExpression());
            if (!(rhs instanceof PsiBinaryExpression)) {
                return;
            }
            PsiBinaryExpression binaryRhs = (PsiBinaryExpression)rhs;
            if (binaryRhs.getROperand() == null) {
                return;
            }
            IElementType expressionTokenType = binaryRhs.getOperationTokenType();
            if (JavaTokenType.EQEQ.equals(expressionTokenType) || JavaTokenType.NE.equals(expressionTokenType)) {
                return;
            }
            if (ReplaceAssignmentWithOperatorAssignmentInspection.this.ignoreLazyOperators && (JavaTokenType.ANDAND.equals(expressionTokenType) || JavaTokenType.OROR.equals(expressionTokenType))) {
                return;
            }
            if (ReplaceAssignmentWithOperatorAssignmentInspection.this.ignoreObscureOperators && (JavaTokenType.XOR.equals(expressionTokenType) || JavaTokenType.PERC.equals(expressionTokenType))) {
                return;
            }
            PsiExpression lOperand = binaryRhs.getLOperand();
            if (SideEffectChecker.mayHaveSideEffects(lhs)) {
                return;
            }
            if (!EquivalenceChecker.expressionsAreEquivalent(lhs, lOperand)) {
                return;
            }
            this.registerError((PsiElement)assignment, assignment);
        }
    }

    private static class ReplaceAssignmentWithOperatorAssignmentFix
    extends InspectionGadgetsFix {
        private final String m_name;

        private ReplaceAssignmentWithOperatorAssignmentFix(PsiAssignmentExpression expression) {
            PsiExpression rhs = expression.getRExpression();
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)PsiUtil.deparenthesizeExpression((PsiExpression)rhs);
            assert (binaryExpression != null);
            PsiJavaToken sign = binaryExpression.getOperationSign();
            String signText = sign.getText();
            if ("&&".equals(signText)) {
                signText = "&";
            } else if ("||".equals(signText)) {
                signText = "|";
            }
            this.m_name = InspectionGadgetsBundle.message("assignment.replaceable.with.operator.replace.quickfix", signText, Character.valueOf('='));
        }

        @NotNull
        public String getName() {
            String string = this.m_name;
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/assignment/ReplaceAssignmentWithOperatorAssignmentInspection$ReplaceAssignmentWithOperatorAssignmentFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(@NotNull Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/assignment/ReplaceAssignmentWithOperatorAssignmentInspection$ReplaceAssignmentWithOperatorAssignmentFix.doFix must not be null");
            }
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiAssignmentExpression)) {
                return;
            }
            PsiAssignmentExpression expression = (PsiAssignmentExpression)element;
            String newExpression = ReplaceAssignmentWithOperatorAssignmentInspection.calculateReplacementExpression(expression);
            ReplaceAssignmentWithOperatorAssignmentFix.replaceExpression((PsiExpression)expression, newExpression);
        }
    }
}

