/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.CollectionUtils;
import com.siyeh.ig.psiutils.LibraryUtil;
import com.siyeh.ig.psiutils.WeakestTypeFinder;
import com.siyeh.ig.ui.MultipleCheckboxOptionsPanel;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeclareCollectionAsInterfaceInspection
extends BaseInspection {
    public boolean ignoreLocalVariables = false;
    public boolean ignorePrivateMethodsAndFields = false;

    @NotNull
    public String getID() {
        if ("CollectionDeclaredAsConcreteClass" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/abstraction/DeclareCollectionAsInterfaceInspection.getID must not return null");
        }
        return "CollectionDeclaredAsConcreteClass";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("collection.declared.by.class.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/abstraction/DeclareCollectionAsInterfaceInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String type = (String)infos[0];
        String string = InspectionGadgetsBundle.message("collection.declared.by.class.problem.descriptor", type);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/abstraction/DeclareCollectionAsInterfaceInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel(this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("collection.declared.by.class.ignore.locals.option", new Object[0]), "ignoreLocalVariables");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("collection.declared.by.class.ignore.private.members.option", new Object[0]), "ignorePrivateMethodsAndFields");
        return optionsPanel;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new DeclareCollectionAsInterfaceFix((String)infos[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new DeclareCollectionAsInterfaceVisitor();
    }

    private class DeclareCollectionAsInterfaceVisitor
    extends BaseInspectionVisitor {
        private DeclareCollectionAsInterfaceVisitor() {
        }

        public void visitVariable(@NotNull PsiVariable variable) {
            PsiMethod method;
            PsiParameter parameter;
            PsiElement scope;
            if (variable == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/abstraction/DeclareCollectionAsInterfaceInspection$DeclareCollectionAsInterfaceVisitor.visitVariable must not be null");
            }
            if (this.isOnTheFly() && variable.hasModifierProperty("public")) {
                return;
            }
            if (DeclareCollectionAsInterfaceInspection.this.ignoreLocalVariables && variable instanceof PsiLocalVariable) {
                return;
            }
            if (DeclareCollectionAsInterfaceInspection.this.ignorePrivateMethodsAndFields && variable instanceof PsiField && variable.hasModifierProperty("private")) {
                return;
            }
            if (variable instanceof PsiParameter && ((scope = (parameter = (PsiParameter)variable).getDeclarationScope()) instanceof PsiMethod ? DeclareCollectionAsInterfaceInspection.this.ignorePrivateMethodsAndFields && (method = (PsiMethod)scope).hasModifierProperty("private") : DeclareCollectionAsInterfaceInspection.this.ignoreLocalVariables)) {
                return;
            }
            PsiType type = variable.getType();
            if (!CollectionUtils.isCollectionClass(type)) {
                return;
            }
            if (LibraryUtil.isOverrideOfLibraryMethodParameter(variable)) {
                return;
            }
            PsiTypeElement typeElement = variable.getTypeElement();
            if (typeElement == null) {
                return;
            }
            PsiJavaCodeReferenceElement reference = typeElement.getInnermostComponentReferenceElement();
            if (reference == null) {
                return;
            }
            PsiElement nameElement = reference.getReferenceNameElement();
            if (nameElement == null) {
                return;
            }
            Collection<PsiClass> weaklings = WeakestTypeFinder.calculateWeakestClassesNecessary((PsiElement)variable, false, true);
            if (weaklings.isEmpty()) {
                return;
            }
            ArrayList<PsiClass> weaklingList = new ArrayList<PsiClass>(weaklings);
            PsiManager manager = variable.getManager();
            GlobalSearchScope scope2 = variable.getResolveScope();
            PsiClassType javaLangObject = PsiType.getJavaLangObject((PsiManager)manager, (GlobalSearchScope)scope2);
            PsiClass objectClass = javaLangObject.resolve();
            weaklingList.remove(objectClass);
            if (weaklingList.isEmpty()) {
                String typeText = type.getCanonicalText();
                String interfaceText = CollectionUtils.getInterfaceForClass(typeText);
                this.registerError(nameElement, interfaceText);
            } else {
                PsiClass weakling = (PsiClass)weaklingList.get(0);
                String qualifiedName = weakling.getQualifiedName();
                this.registerError(nameElement, qualifiedName);
            }
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/abstraction/DeclareCollectionAsInterfaceInspection$DeclareCollectionAsInterfaceVisitor.visitMethod must not be null");
            }
            super.visitMethod(method);
            if (DeclareCollectionAsInterfaceInspection.this.ignorePrivateMethodsAndFields && method.hasModifierProperty("private")) {
                return;
            }
            if (this.isOnTheFly() && method.hasModifierProperty("public")) {
                return;
            }
            PsiType type = method.getReturnType();
            if (type == null || !CollectionUtils.isCollectionClass(type)) {
                return;
            }
            if (LibraryUtil.isOverrideOfLibraryMethod(method)) {
                return;
            }
            PsiTypeElement typeElement = method.getReturnTypeElement();
            if (typeElement == null) {
                return;
            }
            PsiJavaCodeReferenceElement referenceElement = typeElement.getInnermostComponentReferenceElement();
            if (referenceElement == null) {
                return;
            }
            PsiElement nameElement = referenceElement.getReferenceNameElement();
            if (nameElement == null) {
                return;
            }
            Collection<PsiClass> weaklings = WeakestTypeFinder.calculateWeakestClassesNecessary((PsiElement)method, false, true);
            if (weaklings.isEmpty()) {
                return;
            }
            ArrayList<PsiClass> weaklingList = new ArrayList<PsiClass>(weaklings);
            PsiManager manager = method.getManager();
            GlobalSearchScope scope = method.getResolveScope();
            PsiClassType javaLangObject = PsiType.getJavaLangObject((PsiManager)manager, (GlobalSearchScope)scope);
            PsiClass objectClass = javaLangObject.resolve();
            weaklingList.remove(objectClass);
            if (weaklingList.isEmpty()) {
                String typeText = type.getCanonicalText();
                String interfaceText = CollectionUtils.getInterfaceForClass(typeText);
                this.registerError(nameElement, interfaceText);
            } else {
                PsiClass weakling = (PsiClass)weaklingList.get(0);
                this.registerError(nameElement, weakling.getQualifiedName());
            }
        }
    }

    private static class DeclareCollectionAsInterfaceFix
    extends InspectionGadgetsFix {
        private final String typeString;

        DeclareCollectionAsInterfaceFix(String typeString) {
            this.typeString = typeString;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("declare.collection.as.interface.quickfix", this.typeString);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/abstraction/DeclareCollectionAsInterfaceInspection$DeclareCollectionAsInterfaceFix.getName must not return null");
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement grandParent;
            PsiTypeElement[] typeParameterElements;
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiJavaCodeReferenceElement)) {
                return;
            }
            StringBuilder newElementText = new StringBuilder(this.typeString);
            PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)parent;
            PsiReferenceParameterList parameterList = referenceElement.getParameterList();
            if (parameterList != null && (typeParameterElements = parameterList.getTypeParameterElements()).length > 0) {
                newElementText.append('<');
                PsiTypeElement typeParameterElement1 = typeParameterElements[0];
                newElementText.append(typeParameterElement1.getText());
                for (int i = 1; i < typeParameterElements.length; ++i) {
                    newElementText.append(',');
                    PsiTypeElement typeParameterElement = typeParameterElements[i];
                    newElementText.append(typeParameterElement.getText());
                }
                newElementText.append('>');
            }
            if (!((grandParent = parent.getParent()) instanceof PsiTypeElement)) {
                return;
            }
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
            PsiElementFactory factory = facade.getElementFactory();
            PsiType type = factory.createTypeFromText(newElementText.toString(), element);
            PsiTypeElement newTypeElement = factory.createTypeElement(type);
            PsiElement insertedElement = grandParent.replace((PsiElement)newTypeElement);
            JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)project);
            styleManager.shortenClassReferences(insertedElement);
        }
    }
}

