/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.impl.ConcatenationToMessageFormatAction;
import com.intellij.codeInspection.i18n.I18nizeQuickFix;
import com.intellij.codeInspection.i18n.JavaI18nizeQuickFixDialog;
import com.intellij.lang.properties.psi.I18nizedTextGenerator;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class I18nizeConcatenationQuickFix
extends I18nizeQuickFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.i18n.I18nizeConcatenationQuickFix");
    @NonNls
    private static final String PARAMETERS_OPTION_KEY = "PARAMETERS";

    @Override
    public void checkApplicability(PsiFile psiFile, Editor editor) throws IncorrectOperationException {
        PsiBinaryExpression concatenation = ConcatenationToMessageFormatAction.getEnclosingLiteralConcatenation((PsiFile)psiFile, (Editor)editor);
        if (concatenation != null) {
            return;
        }
        String message = CodeInsightBundle.message((String)"quickfix.i18n.concatentation.error", (Object[])new Object[0]);
        throw new IncorrectOperationException(message);
    }

    @Override
    public JavaI18nizeQuickFixDialog createDialog(Project project, Editor editor, PsiFile psiFile) {
        PsiBinaryExpression concatenation = ConcatenationToMessageFormatAction.getEnclosingLiteralConcatenation((PsiFile)psiFile, (Editor)editor);
        PsiLiteralExpression literalExpression = ConcatenationToMessageFormatAction.getContainingLiteral((PsiBinaryExpression)concatenation);
        if (literalExpression == null) {
            return null;
        }
        return this.createDialog(project, psiFile, literalExpression);
    }

    @Override
    @NotNull
    public String getName() {
        String string = CodeInsightBundle.message((String)"quickfix.i18n.concatentation", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/i18n/I18nizeConcatenationQuickFix.getName must not return null");
        }
        return string;
    }

    @Override
    protected PsiElement doReplacementInJava(@NotNull PsiFile psiFile, @NotNull Editor editor, @Nullable PsiLiteralExpression literalExpression, String i18nizedText) throws IncorrectOperationException {
        if (psiFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/i18n/I18nizeConcatenationQuickFix.doReplacementInJava must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/i18n/I18nizeConcatenationQuickFix.doReplacementInJava must not be null");
        }
        PsiBinaryExpression concatenation = ConcatenationToMessageFormatAction.getEnclosingLiteralConcatenation((PsiFile)psiFile, (Editor)editor);
        PsiExpression expression = JavaPsiFacade.getInstance((Project)psiFile.getProject()).getElementFactory().createExpressionFromText(i18nizedText, (PsiElement)concatenation);
        return concatenation.replace((PsiElement)expression);
    }

    private static String composeParametersText(List<PsiExpression> args) {
        StringBuilder result = new StringBuilder();
        Iterator<PsiExpression> iterator = args.iterator();
        while (iterator.hasNext()) {
            PsiExpression psiExpression = iterator.next();
            result.append(psiExpression.getText());
            if (!iterator.hasNext()) continue;
            result.append(",");
        }
        return result.toString();
    }

    @Override
    protected JavaI18nizeQuickFixDialog createDialog(Project project, PsiFile context, PsiLiteralExpression literalExpression) {
        PsiBinaryExpression concatenation = ConcatenationToMessageFormatAction.getEnclosingLiteralConcatenation((PsiElement)literalExpression);
        StringBuffer formatString = new StringBuffer();
        final ArrayList args = new ArrayList();
        try {
            ArrayList argsToCombine = new ArrayList();
            ConcatenationToMessageFormatAction.calculateFormatAndArguments((PsiExpression)concatenation, (StringBuffer)formatString, args, argsToCombine, (boolean)false);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        String value = ConcatenationToMessageFormatAction.prepareString((String)formatString.toString());
        return new JavaI18nizeQuickFixDialog(project, context, literalExpression, value, null, true, true){

            @Override
            @Nullable
            protected String getTemplateName() {
                return this.myResourceBundleManager.getConcatenationTemplateName();
            }

            @Override
            protected String generateText(I18nizedTextGenerator textGenerator, String propertyKey, PropertiesFile propertiesFile, PsiLiteralExpression literalExpression) {
                return textGenerator.getI18nizedConcatenationText(propertyKey, I18nizeConcatenationQuickFix.composeParametersText(args), propertiesFile, literalExpression);
            }

            @Override
            public PsiExpression[] getParameters() {
                return args.toArray(new PsiExpression[args.size()]);
            }

            @Override
            protected void addAdditionalAttributes(Map<String, String> attributes) {
                attributes.put(I18nizeConcatenationQuickFix.PARAMETERS_OPTION_KEY, I18nizeConcatenationQuickFix.composeParametersText(args));
            }
        };
    }
}

