/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.opassign;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.opassign.OperatorAssignmentPredicate;
import com.siyeh.ipp.psiutils.ParenthesesUtils;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ReplaceOperatorAssignmentWithAssignmentIntention
extends MutablyNamedIntention {
    private static final Map<IElementType, IElementType> tokenMap = new HashMap<IElementType, IElementType>();

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        OperatorAssignmentPredicate operatorAssignmentPredicate = new OperatorAssignmentPredicate();
        if (operatorAssignmentPredicate == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ipp/opassign/ReplaceOperatorAssignmentWithAssignmentIntention.getElementPredicate must not return null");
        }
        return operatorAssignmentPredicate;
    }

    @Override
    protected String getTextForElement(PsiElement element) {
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)element;
        PsiJavaToken sign = assignmentExpression.getOperationSign();
        String operator = sign.getText();
        return IntentionPowerPackBundle.message("replace.operator.assignment.with.assignment.intention.name", operator);
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        IElementType signTokenType;
        IElementType newOperatorToken;
        int precedence2;
        PsiBinaryExpression binaryExpression;
        PsiJavaToken javaToken;
        int precedence1;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/opassign/ReplaceOperatorAssignmentWithAssignmentIntention.processIntention must not be null");
        }
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)element;
        PsiJavaToken sign = assignmentExpression.getOperationSign();
        PsiExpression lhs = assignmentExpression.getLExpression();
        PsiExpression rhs = assignmentExpression.getRExpression();
        String operator = sign.getText();
        String newOperator = operator.substring(0, operator.length() - 1);
        String lhsText = lhs.getText();
        String rhsText = rhs == null ? "" : rhs.getText();
        if (rhs instanceof PsiBinaryExpression && ((precedence1 = ParenthesesUtils.getPrecedenceForBinaryOperator(javaToken = (binaryExpression = (PsiBinaryExpression)rhs).getOperationSign())) > (precedence2 = ParenthesesUtils.getPrecedenceForBinaryOperator(newOperatorToken = tokenMap.get(signTokenType = sign.getTokenType()))) || !ParenthesesUtils.isCommutativeBinaryOperator(newOperatorToken))) {
            String expString = ReplaceOperatorAssignmentWithAssignmentIntention.needsCast(rhs) ? lhsText + "=(int)" + lhsText + newOperator + '(' + rhsText + "))" : lhsText + '=' + lhsText + newOperator + '(' + rhsText + ')';
            ReplaceOperatorAssignmentWithAssignmentIntention.replaceExpression(expString, (PsiExpression)assignmentExpression);
            return;
        }
        String expString = ReplaceOperatorAssignmentWithAssignmentIntention.needsCast(rhs) ? lhsText + "=(int)(" + lhsText + newOperator + rhsText + ')' : lhsText + '=' + lhsText + newOperator + rhsText;
        ReplaceOperatorAssignmentWithAssignmentIntention.replaceExpression(expString, (PsiExpression)assignmentExpression);
    }

    private static boolean needsCast(PsiExpression expression) {
        PsiType type = expression.getType();
        return PsiType.LONG.equals(type) || PsiType.DOUBLE.equals(type) || PsiType.FLOAT.equals(type);
    }

    static {
        tokenMap.put(JavaTokenType.PLUSEQ, JavaTokenType.PLUS);
        tokenMap.put(JavaTokenType.MINUSEQ, JavaTokenType.MINUS);
        tokenMap.put(JavaTokenType.ASTERISKEQ, JavaTokenType.ASTERISK);
        tokenMap.put(JavaTokenType.DIVEQ, JavaTokenType.DIV);
        tokenMap.put(JavaTokenType.ANDEQ, JavaTokenType.AND);
        tokenMap.put(JavaTokenType.OREQ, JavaTokenType.OR);
        tokenMap.put(JavaTokenType.XOREQ, JavaTokenType.XOR);
        tokenMap.put(JavaTokenType.PERCEQ, JavaTokenType.PERC);
        tokenMap.put(JavaTokenType.LTLTEQ, JavaTokenType.LTLT);
        tokenMap.put(JavaTokenType.GTGTEQ, JavaTokenType.GTGT);
        tokenMap.put(JavaTokenType.GTGTGTEQ, JavaTokenType.GTGTGT);
    }
}

