/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.junit;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ipp.base.PsiElementPredicate;

class CreateAssertPredicate
implements PsiElementPredicate {
    CreateAssertPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpressionStatement statement = (PsiExpressionStatement)element;
        PsiExpression expression = statement.getExpression();
        PsiElement parent = expression.getParent();
        if (!(parent instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiType type = expression.getType();
        if (!PsiType.BOOLEAN.equals(type)) {
            return false;
        }
        PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethod.class);
        return CreateAssertPredicate.isTestMethod(containingMethod);
    }

    private static boolean isTestMethod(PsiMethod method) {
        if (method == null) {
            return false;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"org.junit.Test", (boolean)true)) {
            return true;
        }
        if (method.hasModifierProperty("abstract") || !method.hasModifierProperty("public")) {
            return false;
        }
        PsiType returnType = method.getReturnType();
        if (returnType == null) {
            return false;
        }
        if (!returnType.equals(PsiType.VOID)) {
            return false;
        }
        PsiParameterList parameterList = method.getParameterList();
        PsiParameter[] parameters = parameterList.getParameters();
        if (parameters.length != 0) {
            return false;
        }
        String methodName = method.getName();
        if (!methodName.startsWith("test")) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        return CreateAssertPredicate.isTestClass(containingClass);
    }

    private static boolean isTestClass(PsiClass aClass) {
        if (aClass == null) {
            return false;
        }
        Project project = aClass.getProject();
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiClass ancestorClass = psiFacade.findClass("junit.framework.TestCase", scope);
        return InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)ancestorClass, (boolean)true);
    }
}

