/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.conditional;

import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.conditional.FlipConditionalPredicate;
import com.siyeh.ipp.psiutils.BoolUtils;
import org.jetbrains.annotations.NotNull;

public class FlipConditionalIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        FlipConditionalPredicate flipConditionalPredicate = new FlipConditionalPredicate();
        if (flipConditionalPredicate == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ipp/conditional/FlipConditionalIntention.getElementPredicate must not return null");
        }
        return flipConditionalPredicate;
    }

    @Override
    public void processIntention(PsiElement element) throws IncorrectOperationException {
        PsiConditionalExpression exp = (PsiConditionalExpression)element;
        PsiExpression condition = exp.getCondition();
        PsiExpression elseExpression = exp.getElseExpression();
        PsiExpression thenExpression = exp.getThenExpression();
        assert (elseExpression != null);
        assert (thenExpression != null);
        String newExpression = BoolUtils.getNegatedExpressionText(condition) + '?' + elseExpression.getText() + ':' + thenExpression.getText();
        FlipConditionalIntention.replaceExpression(newExpression, (PsiExpression)exp);
    }
}

