/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.concatenation;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.concatenation.StringConcatPredicate;
import com.siyeh.ipp.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;

public class JoinConcatenatedStringLiteralsIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        StringConcatPredicate stringConcatPredicate = new StringConcatPredicate();
        if (stringConcatPredicate == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ipp/concatenation/JoinConcatenatedStringLiteralsIntention.getElementPredicate must not return null");
        }
        return stringConcatPredicate;
    }

    @Override
    public void processIntention(PsiElement element) throws IncorrectOperationException {
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)element.getParent();
        assert (binaryExpression != null);
        PsiBinaryExpression copy = (PsiBinaryExpression)binaryExpression.copy();
        PsiExpression lhs = copy.getLOperand();
        String newExpression = "";
        if (lhs instanceof PsiBinaryExpression) {
            PsiBinaryExpression lhsBinaryExpression = (PsiBinaryExpression)lhs;
            newExpression = newExpression + JoinConcatenatedStringLiteralsIntention.getLeftSideText(lhsBinaryExpression);
            PsiExpression rightSide = lhsBinaryExpression.getROperand();
            assert (rightSide != null);
            lhs.replace((PsiElement)rightSide);
        }
        newExpression = newExpression + '\"' + JoinConcatenatedStringLiteralsIntention.computeConstantStringExpression(copy) + '\"';
        JoinConcatenatedStringLiteralsIntention.replaceExpression(newExpression, (PsiExpression)binaryExpression);
    }

    private static String computeConstantStringExpression(PsiBinaryExpression expression) {
        PsiExpression lhs = expression.getLOperand();
        Object lhsConstant = ExpressionUtils.computeConstantExpression(lhs);
        String lhsText = lhsConstant == null ? "" : lhsConstant.toString();
        String result = lhsText.length() == 0 ? "" : lhsText;
        PsiExpression rhs = expression.getROperand();
        Object rhsConstant = ExpressionUtils.computeConstantExpression(rhs);
        if (rhsConstant != null) {
            result = result + rhsConstant.toString();
        }
        result = StringUtil.escapeStringCharacters((String)result);
        return result;
    }

    private static String getLeftSideText(PsiBinaryExpression binaryExpression) {
        PsiExpression lhs = binaryExpression.getLOperand();
        PsiJavaToken sign = binaryExpression.getOperationSign();
        return lhs.getText() + sign.getText();
    }
}

