/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.concatenation;

import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.concatenation.SimpleStringConcatenationPredicate;
import com.siyeh.ipp.psiutils.ExpressionUtils;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import org.jetbrains.annotations.NotNull;

public class CopyConcatenatedStringToClipboardIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        SimpleStringConcatenationPredicate simpleStringConcatenationPredicate = new SimpleStringConcatenationPredicate();
        if (simpleStringConcatenationPredicate == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ipp/concatenation/CopyConcatenatedStringToClipboardIntention.getElementPredicate must not return null");
        }
        return simpleStringConcatenationPredicate;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        PsiType type;
        PsiBinaryExpression binaryExpression;
        IElementType tokenType;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/concatenation/CopyConcatenatedStringToClipboardIntention.processIntention must not be null");
        }
        if (!(element instanceof PsiBinaryExpression)) {
            return;
        }
        PsiBinaryExpression concatenationExpression = (PsiBinaryExpression)element;
        PsiElement parent = concatenationExpression.getParent();
        while (parent instanceof PsiBinaryExpression && (tokenType = (binaryExpression = (PsiBinaryExpression)parent).getOperationTokenType()) == JavaTokenType.PLUS && (type = binaryExpression.getType()) != null && type.equalsToText("java.lang.String")) {
            concatenationExpression = binaryExpression;
            parent = concatenationExpression.getParent();
        }
        StringBuilder text = new StringBuilder();
        CopyConcatenatedStringToClipboardIntention.buildContatenationText((PsiExpression)concatenationExpression, text);
        String string = text.toString();
        String unescapedString = StringUtil.unescapeStringCharacters((String)string);
        StringSelection contents = new StringSelection(unescapedString);
        CopyPasteManager.getInstance().setContents((Transferable)contents);
    }

    private static void buildContatenationText(PsiExpression expression, StringBuilder out) {
        if (expression instanceof PsiLiteralExpression) {
            String text = expression.getText();
            PsiType type = expression.getType();
            if (type != null && (type.equalsToText("java.lang.String") || type.equalsToText("char"))) {
                int textLength = text.length();
                if (textLength > 2) {
                    out.append(text.substring(1, textLength - 1));
                }
            } else {
                out.append(text);
            }
        } else if (expression instanceof PsiBinaryExpression) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
            Object result = ExpressionUtils.computeConstantExpression(expression);
            if (result != null) {
                out.append(result.toString());
            } else {
                PsiExpression lhs = binaryExpression.getLOperand();
                CopyConcatenatedStringToClipboardIntention.buildContatenationText(lhs, out);
                PsiExpression rhs = binaryExpression.getROperand();
                if (rhs != null) {
                    CopyConcatenatedStringToClipboardIntention.buildContatenationText(rhs, out);
                }
            }
        } else {
            out.append('?');
        }
    }
}

