/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.update;

import java.io.File;
import org.jetbrains.idea.svn.SvnVcs;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class UpdateRootInfo {
    private String myUrl;
    private SVNRevision myRevision = SVNRevision.HEAD;
    private boolean myUpdateToSpecifiedRevision = false;

    public UpdateRootInfo(File file, SvnVcs vcs) {
        try {
            SVNWCClient wcClient = vcs.createWCClient();
            SVNInfo info = wcClient.doInfo(file, SVNRevision.WORKING);
            if (info != null) {
                SVNURL url = info.getURL();
                this.myUrl = url.toString();
            } else {
                this.myUrl = "";
            }
        }
        catch (SVNException e) {
            this.myUrl = "";
        }
    }

    public SVNURL getUrl() {
        try {
            return SVNURL.parseURIEncoded((String)this.myUrl);
        }
        catch (SVNException e) {
            return null;
        }
    }

    public String getUrlAsString() {
        return this.myUrl;
    }

    public SVNRevision getRevision() {
        return this.myRevision;
    }

    public boolean isUpdateToRevision() {
        return this.myUpdateToSpecifiedRevision;
    }

    public void setUrl(String text) {
        this.myUrl = text;
    }

    public void setUpdateToRevision(boolean value) {
        this.myUpdateToSpecifiedRevision = value;
    }

    public void setRevision(SVNRevision svnRevision) {
        this.myRevision = svnRevision;
    }
}

