/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.Consumer;
import com.intellij.util.messages.Topic;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.integrate.ByNumberChangeListComparator;
import org.jetbrains.idea.svn.integrate.GroupSplitter;
import org.jetbrains.idea.svn.integrate.IMerger;
import org.jetbrains.idea.svn.integrate.Splitter;
import org.jetbrains.idea.svn.update.UpdateEventHandler;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNDiffClient;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNRevisionRange;

public class GroupMerger
implements IMerger {
    protected final List<CommittedChangeList> myChangeLists;
    protected final File myTarget;
    protected final SVNDiffClient myDiffClient;
    private final ProgressIndicator myProgressIndicator;
    protected final SVNURL myCurrentBranchUrl;
    private final StringBuilder myCommitMessage;
    protected final SvnConfiguration mySvnConfig;
    private final Project myProject;
    private final String myBranchName;
    private final boolean myInverseRange;
    private final boolean myDryRun;
    private final Splitter mySplitter;
    private int myPackStart;
    private int myPackEnd;
    public static final Topic<CommittedChangesMergedStateChanged> COMMITTED_CHANGES_MERGED_STATE = new Topic("COMMITTED_CHANGES_MERGED_STATE", CommittedChangesMergedStateChanged.class);

    public GroupMerger(SvnVcs vcs, List<CommittedChangeList> changeLists, File target, UpdateEventHandler handler, SVNURL currentBranchUrl, String branchName, boolean inverseRange, boolean dryRun, boolean stepByStep) {
        this.myBranchName = branchName;
        this.myInverseRange = inverseRange;
        this.myDryRun = dryRun;
        this.myProject = vcs.getProject();
        this.mySvnConfig = SvnConfiguration.getInstanceChecked(vcs.getProject());
        this.myCurrentBranchUrl = currentBranchUrl;
        this.myDiffClient = vcs.createDiffClient();
        this.myChangeLists = changeLists;
        Collections.sort(this.myChangeLists, ByNumberChangeListComparator.getInstance());
        this.mySplitter = stepByStep ? new StepByStepSplitter(this.myChangeLists) : new GroupSplitter(this.myChangeLists);
        this.myTarget = target;
        this.myProgressIndicator = ProgressManager.getInstance().getProgressIndicator();
        this.myDiffClient.setEventHandler((ISVNEventHandler)handler);
        this.myDiffClient.setMergeOptions(new SVNDiffOptions(this.mySvnConfig.IGNORE_SPACES_IN_MERGE, this.mySvnConfig.IGNORE_SPACES_IN_MERGE, this.mySvnConfig.IGNORE_SPACES_IN_MERGE));
        this.myCommitMessage = new StringBuilder();
        this.myPackEnd = -1;
        this.myPackStart = -1;
    }

    @Override
    public boolean hasNext() {
        return this.mySplitter.hasNext();
    }

    @Override
    public void mergeNext() throws SVNException {
        int step = this.mySplitter.step();
        this.myPackStart = this.myPackEnd + 1;
        this.myPackEnd = this.myPackStart + step - 1;
        if (this.myProgressIndicator != null) {
            String numbersBeingMerged = this.myPackStart + 1 == this.myPackEnd ? "" + this.myChangeLists.get(this.myPackStart) : "" + this.myChangeLists.get(this.myPackStart) + "-" + this.myChangeLists.get(this.myPackEnd);
            this.myProgressIndicator.setText2("Merging changelist(s)" + numbersBeingMerged);
        }
        this.doMerge();
        this.appendComment();
    }

    private void appendComment() {
        if (this.myCommitMessage.length() == 0) {
            this.myCommitMessage.append("Merged from ").append(this.myBranchName);
        }
        for (int i = this.myPackStart; i <= this.myPackEnd; ++i) {
            CommittedChangeList list = this.myChangeLists.get(i);
            String nextComment = list.getComment().trim();
            this.myCommitMessage.append('\n');
            if (nextComment.length() > 0) {
                this.myCommitMessage.append(nextComment);
            }
            this.myCommitMessage.append(" [from revision ").append(list.getNumber()).append("]");
        }
    }

    protected SVNRevisionRange createRange() {
        SVNRevision start = SVNRevision.create((long)(this.myChangeLists.get(this.myPackStart).getNumber() - 1L));
        SVNRevision end = SVNRevision.create((long)this.myChangeLists.get(this.myPackEnd).getNumber());
        return this.myInverseRange ? new SVNRevisionRange(end, start) : new SVNRevisionRange(start, end);
    }

    protected void doMerge() throws SVNException {
        this.myDiffClient.doMerge(this.myCurrentBranchUrl, SVNRevision.UNDEFINED, Collections.singletonList(this.createRange()), this.myTarget, SVNDepth.INFINITY, true, true, this.mySvnConfig.MERGE_DRY_RUN, this.myDryRun);
    }

    @NonNls
    private List<CommittedChangeList> getTail() {
        return this.myPackStart < this.myChangeLists.size() ? new ArrayList<CommittedChangeList>(this.myChangeLists.subList(this.myPackStart, this.myChangeLists.size())) : Collections.emptyList();
    }

    @Override
    public void getInfo(Consumer<String> holder, boolean getLatest) {
        if (getLatest && this.myPackStart != -1) {
            StringBuilder sb = new StringBuilder("Changelist(s) :");
            for (int i = this.myPackStart; i <= this.myPackEnd; ++i) {
                CommittedChangeList list = this.myChangeLists.get(i);
                String nextComment = list.getComment().trim().replace('\n', '|');
                sb.append("\n" + list.getNumber()).append(" (").append(nextComment).append(")");
            }
            sb.append(" merging faced problems");
            holder.consume((Object)sb.toString());
        }
        this.getSkipped(holder);
    }

    @Override
    public void getSkipped(Consumer<String> holder) {
        List<CommittedChangeList> tail = this.getTail();
        if (!tail.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < tail.size(); ++i) {
                CommittedChangeList list = tail.get(i);
                if (i != 0) {
                    sb.append(',');
                }
                sb.append(list.getNumber()).append(" (").append(list.getComment().replace('\n', '|')).append(')');
            }
            holder.consume((Object)SvnBundle.message("action.Subversion.integrate.changes.warning.skipped.lists.text", sb.toString()));
        }
    }

    @Override
    public String getComment() {
        return this.myCommitMessage.toString();
    }

    @Override
    @Nullable
    public File getMergeInfoHolder() {
        return this.myTarget;
    }

    @Override
    public void afterProcessing() {
        ((CommittedChangesMergedStateChanged)this.myProject.getMessageBus().syncPublisher(COMMITTED_CHANGES_MERGED_STATE)).event(new ArrayList<CommittedChangeList>(this.myChangeLists.subList(0, this.myPackEnd > 0 ? this.myPackEnd : this.myChangeLists.size())));
    }

    private static class StepByStepSplitter
    extends Splitter {
        private final int myTotal;
        private int myCnt;

        private StepByStepSplitter(List<CommittedChangeList> lists) {
            super(lists);
            this.myTotal = lists.size();
            this.myCnt = 0;
        }

        @Override
        public int step() {
            ++this.myCnt;
            return 1;
        }

        @Override
        public boolean hasNext() {
            return this.myCnt < this.myTotal;
        }
    }

    public static interface CommittedChangesMergedStateChanged {
        public void event(List<CommittedChangeList> var1);
    }
}

