/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs.browser;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.ArrayUtil;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.dialogs.browser.MessageBoxCellRenderer;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;

public class MkdirOptionsDialog
extends DialogWrapper {
    private SVNURL myURL;
    private JTextArea myCommitMessage;
    private JTextField myNameField;
    private JLabel myURLLabel;
    private JComboBox myMessagesBox;
    private JPanel myMainPanel;
    private JLabel myRecentMessagesLabel;
    private final SVNURL myOriginalURL;

    public MkdirOptionsDialog(Project project, SVNURL url) {
        super(project, true);
        this.myOriginalURL = url;
        try {
            this.$$$setupUI$$$();
            this.myURL = url.appendPath("NewFolder", true);
        }
        catch (SVNException ignore) {
            // empty catch block
        }
        this.setTitle("New Remote Folder");
        this.init();
        this.myURLLabel.setText(this.myURL.toString());
        this.myNameField.selectAll();
        this.myNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                MkdirOptionsDialog.this.updateURL();
            }
        });
        if (!project.isDefault()) {
            ArrayList messages = VcsConfiguration.getInstance((Project)project).getRecentMessages();
            Collections.reverse(messages);
            String[] model = ArrayUtil.toStringArray((Collection)messages);
            this.myMessagesBox.setModel(new DefaultComboBoxModel<String>(model));
            this.myMessagesBox.setRenderer(new MessageBoxCellRenderer());
        } else {
            this.myRecentMessagesLabel.setVisible(false);
            this.myMessagesBox.setVisible(false);
        }
        String lastMessage = VcsConfiguration.getInstance((Project)project).getLastNonEmptyCommitMessage();
        if (lastMessage != null) {
            this.myCommitMessage.setText(lastMessage);
            this.myCommitMessage.selectAll();
        }
        this.myMessagesBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MkdirOptionsDialog.this.myCommitMessage.setText(MkdirOptionsDialog.this.myMessagesBox.getSelectedItem().toString());
                MkdirOptionsDialog.this.myCommitMessage.selectAll();
            }
        });
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "svn4idea.mkdir.options";
    }

    public String getCommitMessage() {
        return this.myCommitMessage.getText();
    }

    public SVNURL getURL() {
        if (this.getOKAction().isEnabled()) {
            try {
                return SVNURL.parseURIEncoded((String)this.myURLLabel.getText());
            }
            catch (SVNException sVNException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getName() {
        return this.myNameField.getText();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }

    private void updateURL() {
        String newName = this.myNameField.getText();
        if (newName == null || "".equals(newName)) {
            this.myURLLabel.setText(this.myOriginalURL.toString());
            this.getOKAction().setEnabled(false);
            return;
        }
        try {
            this.myURLLabel.setText(this.myOriginalURL.appendPath(newName, false).toString());
            this.getOKAction().setEnabled(true);
        }
        catch (SVNException e) {
            this.myURLLabel.setText(this.myOriginalURL.toString());
            this.getOKAction().setEnabled(false);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JLabel jLabel;
        JTextArea jTextArea;
        JTextField jTextField;
        JLabel jLabel2;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Remote Folder URL:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jLabel3, gridBagConstraints);
        this.myURLLabel = jLabel2 = new JLabel();
        Font font = jLabel2.getFont();
        jLabel2.setFont(new Font(font.getName(), 1, font.getSize()));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jLabel2, gridBagConstraints2);
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Remote Folder Name:");
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jLabel4, gridBagConstraints3);
        this.myNameField = jTextField = new JTextField();
        jTextField.setSelectionEnd(9);
        jTextField.setText("NewFolder");
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.gridy = 1;
        gridBagConstraints4.gridwidth = 2;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jTextField, gridBagConstraints4);
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Commit Message:");
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.gridy = 2;
        gridBagConstraints5.gridwidth = 3;
        gridBagConstraints5.anchor = 17;
        gridBagConstraints5.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jLabel5, gridBagConstraints5);
        JScrollPane jScrollPane = new JScrollPane();
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 0;
        gridBagConstraints6.gridy = 3;
        gridBagConstraints6.gridwidth = 3;
        gridBagConstraints6.weightx = 1.0;
        gridBagConstraints6.weighty = 1.0;
        gridBagConstraints6.anchor = 11;
        gridBagConstraints6.fill = 1;
        gridBagConstraints6.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jScrollPane, gridBagConstraints6);
        this.myCommitMessage = jTextArea = new JTextArea();
        jTextArea.setRows(10);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setLineWrap(true);
        jTextArea.setText("");
        jScrollPane.setViewportView(jTextArea);
        this.myRecentMessagesLabel = jLabel = new JLabel();
        jLabel.setText("Recent Messages: ");
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.gridx = 0;
        gridBagConstraints7.gridy = 4;
        gridBagConstraints7.gridwidth = 3;
        gridBagConstraints7.anchor = 11;
        gridBagConstraints7.fill = 2;
        gridBagConstraints7.insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jLabel, gridBagConstraints7);
        this.myMessagesBox = jComboBox = new JComboBox();
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.gridx = 0;
        gridBagConstraints8.gridy = 5;
        gridBagConstraints8.gridwidth = 3;
        gridBagConstraints8.fill = 2;
        gridBagConstraints8.insets = new Insets(2, 2, 2, 2);
        jPanel.add(jComboBox, gridBagConstraints8);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

