/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.dialogs.SvnMapDialog;
import org.jetbrains.idea.svn.dialogs.WCInfo;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class SvnFormatWorker
extends Task.Backgroundable {
    private List<Throwable> myExceptions;
    private final Project myProject;
    private final WorkingCopyFormat myNewFormat;
    private final List<WCInfo> myWcInfos;
    private List<LocalChangeList> myBeforeChangeLists;
    private final SvnVcs myVcs;

    public SvnFormatWorker(Project project, WorkingCopyFormat newFormat, List<WCInfo> wcInfos) {
        super(project, SvnBundle.message("action.change.wcopy.format.task.title", new Object[0]), false, DEAF);
        this.myProject = project;
        this.myNewFormat = newFormat;
        this.myExceptions = new ArrayList<Throwable>();
        this.myWcInfos = wcInfos;
        this.myVcs = SvnVcs.getInstance(this.myProject);
    }

    public SvnFormatWorker(Project project, WorkingCopyFormat newFormat, WCInfo wcInfo) {
        this(project, newFormat, Collections.singletonList(wcInfo));
    }

    public void checkForOutsideCopies() {
        boolean canceled = false;
        Iterator<WCInfo> iterator = this.myWcInfos.iterator();
        while (iterator.hasNext()) {
            WCInfo wcInfo = iterator.next();
            if (wcInfo.isIsWcRoot()) continue;
            File path = new File(wcInfo.getPath());
            path = SvnUtil.getWorkingCopyRoot(path);
            int result = Messages.showYesNoCancelDialog((String)SvnBundle.message("upgrade.format.clarify.for.outside.copies.text", path), (String)SvnBundle.message("action.change.wcopy.format.task.title", new Object[0]), (Icon)Messages.getWarningIcon());
            if (1 == result) {
                canceled = true;
                break;
            }
            if (0 == result) continue;
            iterator.remove();
        }
        if (canceled) {
            this.myWcInfos.clear();
        }
    }

    public boolean haveStuffToConvert() {
        return !this.myWcInfos.isEmpty();
    }

    public void onCancel() {
        this.onSuccess();
    }

    public void onSuccess() {
        if (this.myProject.isDisposed()) {
            return;
        }
        if (!this.myExceptions.isEmpty()) {
            ArrayList<String> messages = new ArrayList<String>();
            for (Throwable exception : this.myExceptions) {
                messages.add(exception.getMessage());
            }
            AbstractVcsHelper.getInstance((Project)this.myProject).showErrors(Collections.singletonList(new VcsException(messages)), SvnBundle.message("action.change.wcopy.format.task.title", new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/svn/dialogs/SvnFormatWorker.run must not be null");
        }
        ProjectLevelVcsManager.getInstanceChecked((Project)this.myProject).startBackgroundVcsOperation();
        indicator.setIndeterminate(true);
        boolean supportsChangelists = this.myNewFormat.supportsChangelists();
        if (supportsChangelists) {
            this.myBeforeChangeLists = ChangeListManager.getInstanceChecked((Project)this.myProject).getChangeListsCopy();
        }
        SVNWCClient wcClient = this.myVcs.createWCClient();
        try {
            for (WCInfo wcInfo : this.myWcInfos) {
                File path = new File(wcInfo.getPath());
                if (!wcInfo.isIsWcRoot()) {
                    path = SvnUtil.getWorkingCopyRoot(path);
                }
                indicator.setText(SvnBundle.message("action.change.wcopy.format.task.progress.text", path.getAbsolutePath(), SvnUtil.formatRepresentation(wcInfo.getFormat()), SvnUtil.formatRepresentation(this.myNewFormat)));
                try {
                    wcClient.doSetWCFormat(path, this.myNewFormat.getFormat());
                }
                catch (Throwable e) {
                    this.myExceptions.add(e);
                }
            }
        }
        finally {
            ProjectLevelVcsManager.getInstance((Project)this.myProject).stopBackgroundVcsOperation();
            if (supportsChangelists) {
                SvnVcs.getInstance(this.myProject).processChangeLists(this.myBeforeChangeLists);
            }
            ((Runnable)ApplicationManager.getApplication().getMessageBus().syncPublisher(SvnMapDialog.WC_CONVERTED)).run();
        }
    }
}

