/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.dialogs.RepositoryBrowserComponent;
import org.jetbrains.idea.svn.dialogs.browser.UrlOpeningExpander;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.io.SVNRepository;

public class SelectLocationDialog
extends DialogWrapper {
    private Project myProject;
    private RepositoryBrowserComponent myRepositoryBrowser;
    private SVNURL myURL;
    private String myDstName;
    private String myDstLabel;
    private JTextField myDstText;
    private boolean myIsShowFiles;
    @NonNls
    private static final String HELP_ID = "vcs.subversion.common";

    @Nullable
    public static String selectLocation(Project project, String url) {
        try {
            SVNURL.parseURIEncoded((String)url);
            SVNURL svnurl = SelectLocationDialog.initRoot(project, url);
            SelectLocationDialog dialog = new SelectLocationDialog(project, svnurl, null, null, true);
            dialog.show();
            if (!dialog.isOK()) {
                return null;
            }
            return dialog.getSelectedURL();
        }
        catch (SVNException e) {
            Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)SvnBundle.message("dialog.title.select.repository.location", new Object[0]));
            return null;
        }
    }

    @Nullable
    public static String selectCopyDestination(Project project, String url, String dstLabel, String dstName, boolean showFiles) {
        try {
            SVNURL.parseURIEncoded((String)url);
            SVNURL svnurl = SelectLocationDialog.initRoot(project, url);
            SelectLocationDialog dialog = new SelectLocationDialog(project, svnurl, dstLabel, dstName, showFiles);
            dialog.show();
            if (!dialog.isOK()) {
                return null;
            }
            String result = dialog.getSelectedURL();
            String name = dialog.getDestinationName();
            return SVNPathUtil.append((String)result, (String)name);
        }
        catch (SVNException e) {
            Messages.showErrorDialog((Project)project, (String)SvnBundle.message("select.location.invalid.url.message", url), (String)SvnBundle.message("dialog.title.select.repository.location", new Object[0]));
            return null;
        }
    }

    private SelectLocationDialog(Project project, SVNURL url, String dstLabel, String dstName, boolean showFiles) throws SVNException {
        super(project, true);
        this.myProject = project;
        this.myDstLabel = dstLabel;
        this.myDstName = dstName;
        this.myURL = url;
        this.myIsShowFiles = showFiles;
        this.setTitle(SvnBundle.message("dialog.title.select.repository.location", new Object[0]));
        this.getHelpAction().setEnabled(true);
        this.init();
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp(HELP_ID);
    }

    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
    }

    protected String getDimensionServiceKey() {
        return "svn.repositoryBrowser";
    }

    private static SVNURL initRoot(final Project project, final String urlString) throws SVNException {
        final Ref result = new Ref();
        final Ref excRef = new Ref();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                try {
                    SVNRepository repos = SvnVcs.getInstance(project).createRepository(urlString);
                    result.set((Object)repos.getRepositoryRoot(true));
                    repos.closeSession();
                }
                catch (SVNException e) {
                    excRef.set((Object)e);
                }
            }
        }, "Detecting repository root", true, project);
        if (!excRef.isNull()) {
            throw (SVNException)((Object)excRef.get());
        }
        return (SVNURL)result.get();
    }

    protected void init() {
        super.init();
        String urlString = this.myURL.toString();
        this.myRepositoryBrowser.setRepositoryURL(this.myURL, this.myIsShowFiles, new UrlOpeningExpander.Factory(urlString, urlString));
        this.myRepositoryBrowser.addChangeListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                SelectLocationDialog.this.getOKAction().setEnabled(SelectLocationDialog.this.isOKActionEnabled());
            }
        });
    }

    protected void dispose() {
        super.dispose();
        Disposer.dispose((Disposable)this.myRepositoryBrowser);
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.insets = new Insets(2, 2, 2, 2);
        gc.gridwidth = 2;
        gc.gridheight = 1;
        gc.gridx = 0;
        gc.gridy = 0;
        gc.anchor = 17;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        this.myRepositoryBrowser = new RepositoryBrowserComponent(SvnVcs.getInstance(this.myProject));
        panel.add((Component)this.myRepositoryBrowser, gc);
        if (this.myDstName != null) {
            ++gc.gridy;
            gc.gridwidth = 1;
            gc.gridx = 0;
            gc.fill = 0;
            gc.weightx = 0.0;
            gc.weighty = 0.0;
            JLabel dstLabel = new JLabel(this.myDstLabel);
            panel.add((Component)dstLabel, gc);
            ++gc.gridx;
            gc.weightx = 1.0;
            gc.fill = 2;
            this.myDstText = new JTextField();
            this.myDstText.setText(this.myDstName);
            this.myDstText.selectAll();
            panel.add((Component)this.myDstText, gc);
            this.myDstText.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    SelectLocationDialog.this.getOKAction().setEnabled(SelectLocationDialog.this.isOKActionEnabled());
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    SelectLocationDialog.this.getOKAction().setEnabled(SelectLocationDialog.this.isOKActionEnabled());
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    SelectLocationDialog.this.getOKAction().setEnabled(SelectLocationDialog.this.isOKActionEnabled());
                }
            });
            dstLabel.setLabelFor(this.myDstText);
            gc.gridx = 0;
            ++gc.gridy;
            gc.gridwidth = 2;
            panel.add((Component)new JSeparator(), gc);
        }
        return panel;
    }

    public JComponent getPreferredFocusedComponent() {
        return (JComponent)this.myRepositoryBrowser.getPreferredFocusedComponent();
    }

    public boolean shouldCloseOnCross() {
        return true;
    }

    public boolean isOKActionEnabled() {
        boolean ok;
        boolean bl = ok = this.myRepositoryBrowser.getSelectedURL() != null;
        if (ok && this.myDstText != null) {
            return this.myDstText.getText().trim().length() > 0;
        }
        return ok;
    }

    public String getDestinationName() {
        return SVNEncodingUtil.uriEncode((String)this.myDstText.getText().trim());
    }

    public String getSelectedURL() {
        return this.myRepositoryBrowser.getSelectedURL();
    }

    public SVNURL getSelectedSVNURL() {
        return this.myRepositoryBrowser.getSelectedSVNURL();
    }
}

