/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;

public class MergeFromAction
extends DumbAwareAction {
    public MergeFromAction() {
        super("Merge from...", "One-click merge for feature branches", null);
    }

    public void actionPerformed(AnActionEvent e) {
        ToolWindow window;
        if (!this.isEnabled(e)) {
            return;
        }
        DataContext dc = e.getDataContext();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dc);
        if (project == null) {
            return;
        }
        ToolWindowManager manager = ToolWindowManager.getInstance((Project)project);
        if (manager != null && (window = manager.getToolWindow(ChangesViewContentManager.TOOLWINDOW_ID)) != null) {
            window.show(null);
            ContentManager cm = window.getContentManager();
            Content content = cm.findContent(SvnBundle.message("dialog.show.svn.map.title", new Object[0]));
            if (content != null) {
                cm.setSelectedContent(content, true);
            }
        }
    }

    public void update(AnActionEvent e) {
        DataContext dc = e.getDataContext();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dc);
        if (project == null || project.isDefault()) {
            return;
        }
        e.getPresentation().setVisible(this.isEnabled(e));
    }

    private boolean isEnabled(AnActionEvent e) {
        DataContext dc = e.getDataContext();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dc);
        if (project == null || project.isDefault()) {
            return false;
        }
        VirtualFile[] files = ProjectLevelVcsManager.getInstance((Project)project).getRootsUnderVcs((AbstractVcs)SvnVcs.getInstance(project));
        return files != null && files.length > 0;
    }
}

