/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.annotate;

import com.intellij.openapi.editor.EditorGutterAction;
import com.intellij.openapi.vcs.annotate.AnnotationListener;
import com.intellij.openapi.vcs.annotate.AnnotationSource;
import com.intellij.openapi.vcs.annotate.AnnotationSourceSwitcher;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspect;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspectAdapter;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.SyncDateFormat;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Cursor;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnEntriesListener;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.actions.ShowAllSubmittedFilesAction;
import org.jetbrains.idea.svn.history.SvnFileRevision;

public class SvnFileAnnotation
implements FileAnnotation {
    private final String myContents;
    private final MyPartiallyCreatedInfos myInfos;
    private static final SyncDateFormat DATE_FORMAT = new SyncDateFormat(SimpleDateFormat.getDateInstance(3));
    private final SvnVcs myVcs;
    private final VirtualFile myFile;
    private final List<AnnotationListener> myListeners = new ArrayList<AnnotationListener>();
    private final Map<Long, SvnFileRevision> myRevisionMap = new HashMap<Long, SvnFileRevision>();
    private final LineAnnotationAspect DATE_ASPECT = new LineAnnotationAspectAdapter(){

        public String getValue(int lineNumber) {
            if (SvnFileAnnotation.this.myInfos.size() <= lineNumber || lineNumber < 0) {
                return "";
            }
            LineInfo lineInfo = SvnFileAnnotation.this.myInfos.get(lineNumber);
            return lineInfo == null ? "" : DATE_FORMAT.format(lineInfo.getDate());
        }
    };
    private final LineAnnotationAspect REVISION_ASPECT = new RevisionAnnotationAspect();
    private final LineAnnotationAspect ORIGINAL_REVISION_ASPECT = new RevisionAnnotationAspect(){

        @Override
        public String getValue(int lineNumber) {
            long value = SvnFileAnnotation.this.myInfos.originalRevision(lineNumber);
            return value == -1L ? "" : String.valueOf(value);
        }

        @Override
        protected long getRevision(int lineNum) {
            return SvnFileAnnotation.this.myInfos.originalRevision(lineNum);
        }

        public String getTooltipText(int lineNumber) {
            if (SvnFileAnnotation.this.myInfos.size() <= lineNumber || lineNumber < 0) {
                return "";
            }
            LineInfo info = SvnFileAnnotation.this.myInfos.get(lineNumber);
            if (info == null) {
                return null;
            }
            SvnFileRevision svnRevision = (SvnFileRevision)SvnFileAnnotation.this.myRevisionMap.get(info.getRevision());
            if (svnRevision != null) {
                String tooltip = "Revision " + info.getRevision() + ": " + svnRevision.getCommitMessage();
                return XmlStringUtil.escapeString((String)tooltip);
            }
            return "";
        }
    };
    private final LineAnnotationAspect AUTHOR_ASPECT = new LineAnnotationAspectAdapter(){

        public String getValue(int lineNumber) {
            if (SvnFileAnnotation.this.myInfos.size() <= lineNumber || lineNumber < 0) {
                return "";
            }
            LineInfo lineInfo = SvnFileAnnotation.this.myInfos.get(lineNumber);
            return lineInfo == null ? "" : lineInfo.getAuthor();
        }
    };
    private final SvnEntriesListener myListener = new SvnEntriesListener(){

        @Override
        public void onEntriesChanged(VirtualFile directory) {
            AnnotationListener[] listeners = SvnFileAnnotation.this.myListeners.toArray(new AnnotationListener[SvnFileAnnotation.this.myListeners.size()]);
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].onAnnotationChanged();
            }
        }
    };
    private final SvnConfiguration myConfiguration;

    public void setRevision(long revision, SvnFileRevision svnRevision) {
        this.myRevisionMap.put(revision, svnRevision);
    }

    public void clearRevisions() {
        this.myRevisionMap.clear();
    }

    private SvnFileRevision getRevision(long revision) {
        SvnFileRevision result = this.myRevisionMap.get(revision);
        if (result != null) {
            return result;
        }
        return null;
    }

    public SvnFileAnnotation(SvnVcs vcs, VirtualFile file, String contents) {
        this.myVcs = vcs;
        this.myFile = file;
        this.myContents = contents;
        this.myVcs.getSvnEntriesFileListener().addListener(this.myListener);
        this.myConfiguration = SvnConfiguration.getInstance(vcs.getProject());
        this.myInfos = new MyPartiallyCreatedInfos();
    }

    public void addListener(AnnotationListener listener) {
        this.myListeners.add(listener);
        this.myConfiguration.addAnnotationListener(listener);
    }

    public void removeListener(AnnotationListener listener) {
        this.myListeners.remove(listener);
        this.myConfiguration.removeAnnotationListener(listener);
    }

    public void dispose() {
        this.myVcs.getSvnEntriesFileListener().removeListener(this.myListener);
    }

    public LineAnnotationAspect[] getAspects() {
        return new LineAnnotationAspect[]{this.REVISION_ASPECT, this.DATE_ASPECT, this.AUTHOR_ASPECT};
    }

    public String getToolTip(int lineNumber) {
        if (this.myInfos.size() <= lineNumber || lineNumber < 0) {
            return "";
        }
        LineInfo info = this.myInfos.get(lineNumber);
        if (info == null) {
            return "";
        }
        SvnFileRevision svnRevision = this.myRevisionMap.get(info.getRevision());
        if (svnRevision != null) {
            if (this.myInfos.getAnnotationSource(lineNumber).showMerged()) {
                return "Merge source revision " + info.getRevision() + ": " + svnRevision.getCommitMessage();
            }
            return "Revision " + info.getRevision() + ": " + svnRevision.getCommitMessage();
        }
        return "";
    }

    public String getAnnotatedContent() {
        return this.myContents;
    }

    public void setLineInfo(int lineNumber, Date date, long revision, String author, @Nullable Date mergeDate, long mergeRevision, @Nullable String mergeAuthor) {
        this.myInfos.appendNumberedLineInfo(lineNumber, date, revision, author, mergeDate, mergeRevision, mergeAuthor);
    }

    public void appendLineInfo(Date date, long revision, String author, @Nullable Date mergeDate, long mergeRevision, @Nullable String mergeAuthor) {
        this.myInfos.appendNumberedLineInfo(date, revision, author, mergeDate, mergeRevision, mergeAuthor);
    }

    @Nullable
    public VcsRevisionNumber originalRevision(int lineNumber) {
        if (this.myInfos.size() <= lineNumber || lineNumber < 0) {
            return null;
        }
        SvnFileRevision revision = this.myRevisionMap.get(this.myInfos.originalRevision(lineNumber));
        return revision == null ? null : revision.getRevisionNumber();
    }

    public VcsRevisionNumber getLineRevisionNumber(int lineNumber) {
        if (this.myInfos.size() <= lineNumber || lineNumber < 0) {
            return null;
        }
        LineInfo info = this.myInfos.get(lineNumber);
        if (info == null) {
            return null;
        }
        SvnFileRevision svnRevision = this.myRevisionMap.get(info.getRevision());
        if (svnRevision != null) {
            return svnRevision.getRevisionNumber();
        }
        return null;
    }

    public List<VcsFileRevision> getRevisions() {
        ArrayList<VcsFileRevision> result = new ArrayList<VcsFileRevision>(this.myRevisionMap.values());
        Collections.sort(result, new Comparator<VcsFileRevision>(){

            @Override
            public int compare(VcsFileRevision o1, VcsFileRevision o2) {
                return -1 * o1.getRevisionNumber().compareTo((Object)o2.getRevisionNumber());
            }
        });
        return result;
    }

    public boolean revisionsNotEmpty() {
        return !this.myRevisionMap.isEmpty();
    }

    @Nullable
    public AnnotationSourceSwitcher getAnnotationSourceSwitcher() {
        return new AnnotationSourceSwitcher(){

            @NotNull
            public AnnotationSource getAnnotationSource(int lineNumber) {
                AnnotationSource annotationSource = SvnFileAnnotation.this.myInfos.getAnnotationSource(lineNumber);
                if (annotationSource == null) {
                    throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/annotate/SvnFileAnnotation$6.getAnnotationSource must not return null");
                }
                return annotationSource;
            }

            public boolean mergeSourceAvailable(int lineNumber) {
                return SvnFileAnnotation.this.myInfos.mergeSourceAvailable(lineNumber);
            }

            @NotNull
            public LineAnnotationAspect getRevisionAspect() {
                LineAnnotationAspect lineAnnotationAspect = SvnFileAnnotation.this.ORIGINAL_REVISION_ASPECT;
                if (lineAnnotationAspect == null) {
                    throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/annotate/SvnFileAnnotation$6.getRevisionAspect must not return null");
                }
                return lineAnnotationAspect;
            }

            @NotNull
            public AnnotationSource getDefaultSource() {
                AnnotationSource annotationSource = AnnotationSource.getInstance((boolean)((SvnFileAnnotation)SvnFileAnnotation.this).myConfiguration.SHOW_MERGE_SOURCES_IN_ANNOTATE);
                if (annotationSource == null) {
                    throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/annotate/SvnFileAnnotation$6.getDefaultSource must not return null");
                }
                return annotationSource;
            }

            public void switchTo(AnnotationSource source) {
                SvnFileAnnotation.this.myInfos.setShowMergeSource(source.showMerged());
            }
        };
    }

    private static class MyInfos {
        private boolean myShowMergeSource;
        private final List<LineInfo> myLineInfos = new ArrayList<LineInfo>();
        private final Map<Integer, LineInfo> myMergeSourceInfos = new HashMap<Integer, LineInfo>();

        private MyInfos() {
        }

        boolean isShowMergeSource() {
            return this.myShowMergeSource;
        }

        void setShowMergeSource(boolean showMergeSource) {
            this.myShowMergeSource = showMergeSource;
        }

        int size() {
            return this.myLineInfos.size();
        }

        void appendNumberedLineInfo(int lineNumber, Date date, long revision, String author, @Nullable Date mergeDate, long mergeRevision, @Nullable String mergeAuthor) {
            if (this.myLineInfos.size() <= lineNumber) {
                // empty if block
            }
        }

        void appendLineInfo(Date date, long revision, String author) {
            this.myLineInfos.add(new LineInfo(date, revision, author));
        }

        /*
         * WARNING - void declaration
         */
        void appendLineInfo(Date date, long revision, String author, @NotNull Date mergeDate, long mergeRevision, @NotNull String string) {
            void mergeAuthor;
            if (mergeDate == null) {
                throw new IllegalArgumentException("Argument 3 for @NotNull parameter of org/jetbrains/idea/svn/annotate/SvnFileAnnotation$MyInfos.appendLineInfo must not be null");
            }
            if (string == null) {
                throw new IllegalArgumentException("Argument 5 for @NotNull parameter of org/jetbrains/idea/svn/annotate/SvnFileAnnotation$MyInfos.appendLineInfo must not be null");
            }
            this.myLineInfos.add(new LineInfo(date, revision, author));
            int idx = this.myLineInfos.size() - 1;
            this.myMergeSourceInfos.put(idx, new LineInfo(mergeDate, mergeRevision, (String)mergeAuthor));
        }

        LineInfo get(int idx) {
            LineInfo lineInfo;
            if (this.myShowMergeSource && (lineInfo = this.myMergeSourceInfos.get(idx)) != null) {
                return lineInfo;
            }
            return this.myLineInfos.get(idx);
        }

        AnnotationSource getAnnotationSource(int line) {
            return this.myShowMergeSource ? AnnotationSource.getInstance((boolean)this.myMergeSourceInfos.containsKey(line)) : AnnotationSource.LOCAL;
        }

        public long originalRevision(int line) {
            if (line >= this.myLineInfos.size()) {
                return -1L;
            }
            return this.myLineInfos.get(line).getRevision();
        }

        public boolean mergeSourceAvailable(int lineNumber) {
            return this.myMergeSourceInfos.containsKey(lineNumber);
        }
    }

    private static class MyPartiallyCreatedInfos {
        private boolean myShowMergeSource;
        private final Map<Integer, LineInfo> myMappedLineInfo;
        private final Map<Integer, LineInfo> myMergeSourceInfos = new HashMap<Integer, LineInfo>();
        private int myMaxIdx = 0;

        private MyPartiallyCreatedInfos() {
            this.myMappedLineInfo = new HashMap<Integer, LineInfo>();
        }

        boolean isShowMergeSource() {
            return this.myShowMergeSource;
        }

        void setShowMergeSource(boolean showMergeSource) {
            this.myShowMergeSource = showMergeSource;
        }

        int size() {
            return this.myMaxIdx + 1;
        }

        void appendNumberedLineInfo(Date date, long revision, String author, @Nullable Date mergeDate, long mergeRevision, @Nullable String mergeAuthor) {
            this.appendNumberedLineInfo(this.myMaxIdx + 1, date, revision, author, mergeDate, mergeRevision, mergeAuthor);
        }

        void appendNumberedLineInfo(int lineNumber, Date date, long revision, String author, @Nullable Date mergeDate, long mergeRevision, @Nullable String mergeAuthor) {
            if (date == null) {
                return;
            }
            if (this.myMappedLineInfo.get(lineNumber) != null) {
                return;
            }
            this.myMaxIdx = this.myMaxIdx < lineNumber ? lineNumber : this.myMaxIdx;
            this.myMappedLineInfo.put(lineNumber, new LineInfo(date, revision, author));
            if (mergeDate != null) {
                this.myMergeSourceInfos.put(lineNumber, new LineInfo(mergeDate, mergeRevision, mergeAuthor));
            }
        }

        LineInfo get(int idx) {
            LineInfo lineInfo;
            if (this.myShowMergeSource && (lineInfo = this.myMergeSourceInfos.get(idx)) != null) {
                return lineInfo;
            }
            return this.myMappedLineInfo.get(idx);
        }

        AnnotationSource getAnnotationSource(int line) {
            return this.myShowMergeSource ? AnnotationSource.getInstance((boolean)this.myMergeSourceInfos.containsKey(line)) : AnnotationSource.LOCAL;
        }

        public long originalRevision(int line) {
            if (line >= this.size()) {
                return -1L;
            }
            LineInfo lineInfo = this.myMappedLineInfo.get(line);
            return lineInfo == null ? -1L : lineInfo.getRevision();
        }

        public boolean mergeSourceAvailable(int lineNumber) {
            return this.myMergeSourceInfos.containsKey(lineNumber);
        }
    }

    private class RevisionAnnotationAspect
    extends LineAnnotationAspectAdapter
    implements EditorGutterAction {
        private RevisionAnnotationAspect() {
        }

        public String getValue(int lineNumber) {
            if (SvnFileAnnotation.this.myInfos.size() <= lineNumber || lineNumber < 0) {
                return "";
            }
            long revision = this.getRevision(lineNumber);
            return revision == -1L ? "" : String.valueOf(revision);
        }

        public Cursor getCursor(int lineNum) {
            long revision = this.getRevision(lineNum);
            return revision == -1L ? Cursor.getPredefinedCursor(0) : Cursor.getPredefinedCursor(12);
        }

        protected long getRevision(int lineNum) {
            LineInfo lineInfo = SvnFileAnnotation.this.myInfos.get(lineNum);
            return lineInfo == null ? -1L : lineInfo.getRevision();
        }

        public void doAction(int lineNum) {
            SvnFileRevision svnRevision;
            if (lineNum >= 0 && lineNum < SvnFileAnnotation.this.myInfos.size() && (svnRevision = (SvnFileRevision)SvnFileAnnotation.this.myRevisionMap.get(this.getRevision(lineNum))) != null) {
                ShowAllSubmittedFilesAction.showSubmittedFiles(SvnFileAnnotation.this.myVcs.getProject(), svnRevision, SvnFileAnnotation.this.myFile);
            }
        }
    }

    static class LineInfo {
        private final Date myDate;
        private final long myRevision;
        private final String myAuthor;

        public LineInfo(Date date, long revision, String author) {
            this.myDate = date;
            this.myRevision = revision;
            this.myAuthor = author;
        }

        public Date getDate() {
            return this.myDate;
        }

        public long getRevision() {
            return this.myRevision;
        }

        public String getAuthor() {
            return this.myAuthor;
        }
    }
}

