/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.annotate;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.annotate.SvnFileAnnotation;
import org.jetbrains.idea.svn.history.SvnFileRevision;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.wc.ISVNAnnotateHandler;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class SvnAnnotationProvider
implements AnnotationProvider {
    private final SvnVcs myVcs;

    public SvnAnnotationProvider(SvnVcs vcs) {
        this.myVcs = vcs;
    }

    public FileAnnotation annotate(VirtualFile file) throws VcsException {
        return this.annotate(file, new SvnFileRevision(this.myVcs, SVNRevision.WORKING, SVNRevision.WORKING, null, null, null, null, null), true);
    }

    public FileAnnotation annotate(VirtualFile file, VcsFileRevision revision) throws VcsException {
        return this.annotate(file, revision, false);
    }

    private FileAnnotation annotate(final VirtualFile file, final VcsFileRevision revision, final boolean loadExternally) throws VcsException {
        if (file.isDirectory()) {
            throw new VcsException(SvnBundle.message("exception.text.cannot.annotate.directory", new Object[0]));
        }
        final FileAnnotation[] annotation = new FileAnnotation[1];
        final VcsException[] exception = new VcsException[1];
        Runnable command = new Runnable(){

            @Override
            public void run() {
                final ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
                try {
                    String contents;
                    File ioFile = new File(file.getPath()).getAbsoluteFile();
                    if (loadExternally) {
                        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                        SvnAnnotationProvider.this.myVcs.createWCClient().doGetFileContents(ioFile, SVNRevision.UNDEFINED, SVNRevision.BASE, true, (OutputStream)buffer);
                        contents = ((Object)LoadTextUtil.getTextByBinaryPresentation((byte[])buffer.toByteArray(), (VirtualFile)file, (boolean)false)).toString();
                    } else {
                        revision.loadContent();
                        contents = ((Object)LoadTextUtil.getTextByBinaryPresentation((byte[])revision.getContent(), (VirtualFile)file, (boolean)false)).toString();
                    }
                    final SvnFileAnnotation result = new SvnFileAnnotation(SvnAnnotationProvider.this.myVcs, file, contents);
                    SVNWCClient wcClient = SvnAnnotationProvider.this.myVcs.createWCClient();
                    SVNInfo info = wcClient.doInfo(ioFile, SVNRevision.WORKING);
                    if (info == null) {
                        exception[0] = new VcsException((Throwable)new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNKNOWN, (String)"File ''{0}'' is not under version control", (Object)ioFile)));
                        return;
                    }
                    String url = info.getURL() == null ? null : info.getURL().toString();
                    SVNLogClient client = SvnAnnotationProvider.this.myVcs.createLogClient();
                    SvnAnnotationProvider.this.setLogClientOptions(client);
                    SVNRevision endRevision = ((SvnFileRevision)revision).getRevision();
                    if (SVNRevision.WORKING.equals((Object)endRevision)) {
                        endRevision = info.getRevision();
                    }
                    if (progress != null) {
                        progress.setText(SvnBundle.message("progress.text.computing.annotation", file.getName()));
                    }
                    ISVNAnnotateHandler annotateHandler = new ISVNAnnotateHandler(){

                        public void handleLine(Date date, long revision, String author, String line) {
                            if (progress != null) {
                                progress.checkCanceled();
                            }
                            result.appendLineInfo(date, revision, author, null, -1L, null);
                        }

                        public void handleLine(Date date, long revision, String author, String line, Date mergedDate, long mergedRevision, String mergedAuthor, String mergedPath, int lineNumber) throws SVNException {
                            if (progress != null) {
                                progress.checkCanceled();
                            }
                            if (revision == -1L) {
                                return;
                            }
                            if (mergedDate != null && revision > mergedRevision) {
                                result.setLineInfo(lineNumber, date, revision, author, mergedDate, mergedRevision, mergedAuthor);
                            } else {
                                result.setLineInfo(lineNumber, date, revision, author, null, -1L, null);
                            }
                        }

                        public boolean handleRevision(Date date, long revision, String author, File contents) throws SVNException {
                            if (progress != null) {
                                progress.checkCanceled();
                            }
                            return false;
                        }

                        public void handleEOF() {
                        }
                    };
                    boolean supportsMergeinfo = SvnUtil.checkRepositoryVersion15(SvnAnnotationProvider.this.myVcs, url);
                    SVNRevision svnRevision = ((SvnRevisionNumber)revision.getRevisionNumber()).getRevision();
                    MySteppedLogGetter logGetter = new MySteppedLogGetter(SvnAnnotationProvider.this.myVcs, ioFile, progress, client, endRevision, result, url);
                    logGetter.go();
                    LinkedList<SVNRevision> rp = logGetter.getRevisionPoints();
                    for (int i = 0; i < rp.size() - 1; ++i) {
                        client.doAnnotate(ioFile, svnRevision, rp.get(i + 1), rp.get(i), true, supportsMergeinfo, annotateHandler, null);
                    }
                    annotation[0] = result;
                }
                catch (SVNException e) {
                    exception[0] = new VcsException((Throwable)e);
                }
                catch (IOException e) {
                    exception[0] = new VcsException((Throwable)e);
                }
                catch (VcsException e) {
                    exception[0] = e;
                }
            }
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(command, SvnBundle.message("action.text.annotate", new Object[0]), false, this.myVcs.getProject());
        } else {
            command.run();
        }
        if (exception[0] != null) {
            throw new VcsException((Throwable)exception[0]);
        }
        return annotation[0];
    }

    public boolean isAnnotationValid(VcsFileRevision rev) {
        return true;
    }

    private void setLogClientOptions(SVNLogClient client) {
        if (SvnConfiguration.getInstance((Project)this.myVcs.getProject()).IGNORE_SPACES_IN_ANNOTATE) {
            client.setDiffOptions(new SVNDiffOptions(true, true, true));
        }
    }

    private static class MySteppedLogGetter {
        private final LinkedList<SVNRevision> myRevisionPoints;
        private final SvnVcs myVcs;
        private final File myIoFile;
        private final ProgressIndicator myProgress;
        private final SVNLogClient myClient;
        private final SVNRevision myEndRevision;
        private final boolean mySupportsMergeinfo;
        private final SvnFileAnnotation myResult;
        private final String myUrl;

        private MySteppedLogGetter(SvnVcs vcs, File ioFile, ProgressIndicator progress, SVNLogClient client, SVNRevision endRevision, SvnFileAnnotation result, String url) {
            this.myVcs = vcs;
            this.myIoFile = ioFile;
            this.myProgress = progress;
            this.myClient = client;
            this.myEndRevision = endRevision;
            this.mySupportsMergeinfo = SvnUtil.checkRepositoryVersion15(this.myVcs, url);
            this.myResult = result;
            this.myUrl = url;
            this.myRevisionPoints = new LinkedList();
        }

        public void go() throws SVNException {
            int maxAnnotateRevisions = SvnConfiguration.getInstance(this.myVcs.getProject()).getMaxAnnotateRevisions();
            boolean longHistory = true;
            if (maxAnnotateRevisions == -1) {
                longHistory = false;
            } else if (this.myEndRevision.getNumber() < (long)maxAnnotateRevisions) {
                longHistory = false;
            }
            if (!longHistory) {
                this.doLog(this.mySupportsMergeinfo, null, 0);
                this.putDefaultBounds();
            } else {
                this.doLog(false, null, 0);
                List<VcsFileRevision> fileRevisionList = this.myResult.getRevisions();
                if (fileRevisionList.size() < maxAnnotateRevisions) {
                    this.putDefaultBounds();
                    if (this.mySupportsMergeinfo) {
                        this.doLog(true, null, 0);
                    }
                    return;
                }
                this.myRevisionPoints.add(((SvnRevisionNumber)fileRevisionList.get(0).getRevisionNumber()).getRevision());
                SVNRevision truncateTo = ((SvnRevisionNumber)fileRevisionList.get(maxAnnotateRevisions - 1).getRevisionNumber()).getRevision();
                this.myRevisionPoints.add(truncateTo);
                this.myResult.clearRevisions();
                if (this.mySupportsMergeinfo) {
                    this.doLog(true, truncateTo, maxAnnotateRevisions);
                }
            }
        }

        private void putDefaultBounds() {
            this.myRevisionPoints.add(this.myEndRevision);
            this.myRevisionPoints.add(SVNRevision.create((long)0L));
        }

        private void doLog(boolean includeMerged, SVNRevision truncateTo, int max) throws SVNException {
            this.myClient.doLog(new File[]{this.myIoFile}, this.myEndRevision, truncateTo == null ? SVNRevision.create((long)1L) : truncateTo, SVNRevision.UNDEFINED, false, false, includeMerged, (long)max, null, new ISVNLogEntryHandler(){

                public void handleLogEntry(SVNLogEntry logEntry) {
                    if (SVNRevision.UNDEFINED.getNumber() == logEntry.getRevision()) {
                        return;
                    }
                    if (MySteppedLogGetter.this.myProgress != null) {
                        MySteppedLogGetter.this.myProgress.checkCanceled();
                        MySteppedLogGetter.this.myProgress.setText2(SvnBundle.message("progress.text2.revision.processed", logEntry.getRevision()));
                    }
                    MySteppedLogGetter.this.myResult.setRevision(logEntry.getRevision(), new SvnFileRevision(MySteppedLogGetter.this.myVcs, SVNRevision.UNDEFINED, logEntry, MySteppedLogGetter.this.myUrl, ""));
                }
            });
        }

        public LinkedList<SVNRevision> getRevisionPoints() {
            return this.myRevisionPoints;
        }
    }
}

