/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnBranchConfigurationManager;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnFileUrlMapping;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigManager;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.dialogs.BranchConfigurationDialog;
import org.jetbrains.idea.svn.integrate.SvnBranchItem;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;

public class SelectBranchPopup {
    private static final String CONFIGURE_MESSAGE = SvnBundle.message("configure.branches.item", new Object[0]);

    private SelectBranchPopup() {
    }

    public static void show(Project project, VirtualFile file, BranchSelectedCallback callback, String title) {
        SvnFileUrlMapping urlMapping = SvnVcs.getInstance(project).getSvnFileUrlMapping();
        SVNURL svnurl = urlMapping.getUrlForFile(new File(file.getPath()));
        if (svnurl == null) {
            return;
        }
        RootUrlInfo rootUrlInfo = urlMapping.getWcRootForUrl(svnurl.toString());
        if (rootUrlInfo == null) {
            return;
        }
        SelectBranchPopup.showForBranchRoot(project, rootUrlInfo.getVirtualFile(), callback, title);
    }

    public static void showForBranchRoot(Project project, VirtualFile vcsRoot, BranchSelectedCallback callback, String title) {
        SelectBranchPopup.showForBranchRoot(project, vcsRoot, callback, title, null);
    }

    public static void showForBranchRoot(Project project, VirtualFile vcsRoot, BranchSelectedCallback callback, String title, Component component) {
        SvnBranchConfigurationNew configuration;
        try {
            configuration = SvnBranchConfigurationManager.getInstance(project).get(vcsRoot);
        }
        catch (VcsException e1) {
            Messages.showErrorDialog((Project)project, (String)SvnBundle.message("getting.branch.configuration.error", e1.getMessage()), (String)title);
            return;
        }
        ArrayList<String> items = new ArrayList<String>();
        if (configuration.getTrunkUrl() != null) {
            items.add(configuration.getTrunkUrl());
        }
        for (String url : configuration.getBranchUrls()) {
            items.add(url);
        }
        items.add(CONFIGURE_MESSAGE);
        BranchBasesPopupStep step = new BranchBasesPopupStep(project, vcsRoot, configuration, callback, items, title, component);
        ListPopup listPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)step);
        step.showPopupAt((JBPopup)listPopup);
    }

    private static class BranchRenderer
    extends JPanel
    implements ListCellRenderer {
        private final JLabel myUrlLabel = new JLabel();
        private final JLabel myDateLabel = new JLabel();

        public BranchRenderer() {
            super(new BorderLayout());
            this.add((Component)this.myUrlLabel, "West");
            this.add((Component)this.myDateLabel, "East");
            this.myUrlLabel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.myDateLabel.setHorizontalAlignment(4);
            this.myDateLabel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.myDateLabel.setForeground(UIUtil.getTextInactiveTextColor());
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected || cellHasFocus) {
                this.setBackground(UIUtil.getListSelectionBackground());
                Color selectedForegroundColor = UIUtil.getListSelectionForeground();
                this.myUrlLabel.setForeground(selectedForegroundColor);
                this.myDateLabel.setForeground(selectedForegroundColor);
                this.setForeground(selectedForegroundColor);
            } else {
                this.setBackground(UIUtil.getListBackground());
                Color foregroundColor = UIUtil.getListForeground();
                this.myUrlLabel.setForeground(foregroundColor);
                this.myDateLabel.setForeground(UIUtil.getTextInactiveTextColor());
                this.setForeground(foregroundColor);
            }
            if (value instanceof String) {
                this.myUrlLabel.setText((String)value);
                this.myDateLabel.setText("");
            } else {
                SvnBranchItem item = (SvnBranchItem)value;
                this.myUrlLabel.setText(SVNPathUtil.tail((String)item.getUrl()));
                long creationMillis = item.getCreationDateMillis();
                this.myDateLabel.setText(creationMillis > 0L ? SimpleDateFormat.getDateInstance(3).format(new Date(creationMillis)) : "");
            }
            return this;
        }
    }

    private static class BranchBasesPopupStep
    extends BaseListPopupStep<String> {
        protected final Project myProject;
        private final VirtualFile myVcsRoot;
        private final SvnBranchConfigurationNew myConfiguration;
        private final boolean myTopLevel;
        private BranchSelectedCallback myCallback;
        private final Component myComponent;
        private static final String REFRESH_MESSAGE = SvnBundle.message("refresh.branches.item", new Object[0]);

        protected BranchBasesPopupStep(Project project, VirtualFile vcsRoot, SvnBranchConfigurationNew configuration, boolean topLevel, BranchSelectedCallback callback, Component component) {
            this.myProject = project;
            this.myVcsRoot = vcsRoot;
            this.myConfiguration = configuration;
            this.myTopLevel = topLevel;
            this.myCallback = callback;
            this.myComponent = component;
        }

        public BranchBasesPopupStep(Project project, VirtualFile vcsRoot, SvnBranchConfigurationNew configuration, BranchSelectedCallback callback, List<String> items, String title, Component component) {
            this(project, vcsRoot, configuration, true, callback, component);
            this.init(title, items, null);
        }

        public ListSeparator getSeparatorAbove(String value) {
            return CONFIGURE_MESSAGE.equals(value) || REFRESH_MESSAGE.equals(value) ? new ListSeparator("") : null;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public String getTextFor(String value) {
            String string;
            int pos = value.lastIndexOf(47);
            if (pos < 0) {
                string = value;
                if (string == null) throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/actions/SelectBranchPopup$BranchBasesPopupStep.getTextFor must not return null");
                return string;
            }
            if (this.myTopLevel && (this.myConfiguration.getTrunkUrl() == null || !value.startsWith(this.myConfiguration.getTrunkUrl()))) {
                string = value.substring(pos + 1) + "...";
                if (string == null) throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/actions/SelectBranchPopup$BranchBasesPopupStep.getTextFor must not return null");
                return string;
            }
            string = value.substring(pos + 1);
            if (string != null) return string;
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/actions/SelectBranchPopup$BranchBasesPopupStep.getTextFor must not return null");
        }

        public boolean hasSubstep(String selectedValue) {
            return false;
        }

        public PopupStep onChosen(final String selectedValue, boolean finalChoice) {
            if (CONFIGURE_MESSAGE.equals(selectedValue)) {
                return this.doFinalStep(new Runnable(){

                    @Override
                    public void run() {
                        BranchConfigurationDialog.configureBranches(BranchBasesPopupStep.this.myProject, BranchBasesPopupStep.this.myVcsRoot, true);
                    }
                });
            }
            if (!this.myTopLevel || selectedValue.equals(this.myConfiguration.getTrunkUrl())) {
                return this.doFinalStep(new Runnable(){

                    @Override
                    public void run() {
                        BranchBasesPopupStep.this.myCallback.branchSelected(BranchBasesPopupStep.this.myProject, BranchBasesPopupStep.this.myConfiguration, selectedValue, -1L);
                    }
                });
            }
            this.showBranchPopup(selectedValue, true);
            return FINAL_CHOICE;
        }

        @Nullable
        private List<SvnBranchItem> loadBranches(final String selectedBranchesHolder, boolean cached) {
            boolean wasCanceled;
            if (cached) {
                return this.myConfiguration.getBranches(selectedBranchesHolder);
            }
            final ArrayList<SvnBranchItem> result = new ArrayList<SvnBranchItem>();
            final ProgressManager pm = ProgressManager.getInstance();
            boolean bl = wasCanceled = !pm.runProcessWithProgressSynchronously(new Runnable(){

                @Override
                public void run() {
                    ProgressIndicator pi = pm.getProgressIndicator();
                    final Semaphore s = new Semaphore();
                    s.down();
                    final Ref completedRef = new Ref();
                    SvnBranchConfigManager manager = SvnBranchConfigurationManager.getInstance(BranchBasesPopupStep.this.myProject).getSvnBranchConfigManager();
                    manager.reloadBranches(BranchBasesPopupStep.this.myVcsRoot, selectedBranchesHolder, new Consumer<List<SvnBranchItem>>(){

                        public void consume(List<SvnBranchItem> svnBranchItems) {
                            result.addAll(svnBranchItems);
                            completedRef.set((Object)true);
                            s.up();
                        }
                    });
                    while (true) {
                        s.waitFor(500L);
                        if (Boolean.TRUE.equals(completedRef.get())) break;
                        pi.checkCanceled();
                    }
                }
            }, SvnBundle.message("compare.with.branch.progress.loading.branches", new Object[0]), true, this.myProject);
            if (wasCanceled) {
                return this.myConfiguration.getBranches(selectedBranchesHolder);
            }
            return result;
        }

        private void showBranchPopup(final String selectedValue, boolean cached) {
            List<SvnBranchItem> branches = this.loadBranches(selectedValue, cached);
            if (branches == null) {
                return;
            }
            Object[] items = new Object[branches.size() + 1];
            System.arraycopy(branches.toArray(), 0, items, 0, branches.size());
            items[items.length - 1] = REFRESH_MESSAGE;
            final JList<Object> branchList = new JList<Object>(items);
            branchList.setCellRenderer(new BranchRenderer());
            JBPopup popup = JBPopupFactory.getInstance().createListPopupBuilder(branchList).setTitle(SVNPathUtil.tail((String)selectedValue)).setResizable(true).setDimensionServiceKey("Svn.CompareWithBranchPopup").setItemChoosenCallback(new Runnable(){

                @Override
                public void run() {
                    if (REFRESH_MESSAGE.equals(branchList.getSelectedValue())) {
                        BranchBasesPopupStep.this.showBranchPopup(selectedValue, false);
                        return;
                    }
                    SvnBranchItem item = (SvnBranchItem)branchList.getSelectedValue();
                    if (item != null) {
                        BranchBasesPopupStep.this.myCallback.branchSelected(BranchBasesPopupStep.this.myProject, BranchBasesPopupStep.this.myConfiguration, item.getUrl(), item.getRevision());
                    }
                }
            }).createPopup();
            this.showPopupAt(popup);
        }

        public void showPopupAt(JBPopup listPopup) {
            if (this.myComponent == null) {
                listPopup.showCenteredInCurrentWindow(this.myProject);
            } else {
                listPopup.showInCenterOf(this.myComponent);
            }
        }
    }

    public static interface BranchSelectedCallback {
        public void branchSelected(Project var1, SvnBranchConfigurationNew var2, String var3, long var4);
    }
}

