/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.TransactionRunnable;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.idea.svn.SvnVcs;

public abstract class BasicAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"org.jetbrains.idea.svn.actions.BasicAction");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(AnActionEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: actionPerformed(id='" + ActionManager.getInstance().getId((AnAction)this) + "')");
        }
        final DataContext dataContext = event.getDataContext();
        final Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        final VirtualFile[] files = (VirtualFile[])PlatformDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        if (LOG.isDebugEnabled() && files != null) {
            LOG.debug("files='" + Arrays.asList(files) + "'");
        }
        if ((files == null || files.length == 0) && this.needsFiles()) {
            return;
        }
        final SvnVcs vcs = SvnVcs.getInstance(project);
        if (!ProjectLevelVcsManager.getInstance((Project)project).checkAllFilesAreUnder((AbstractVcs)vcs, files)) {
            return;
        }
        if (project != null) {
            project.save();
        }
        String actionName = this.getActionName(vcs);
        final AbstractVcsHelper helper = AbstractVcsHelper.getInstance((Project)project);
        LocalHistoryAction action = LocalHistoryAction.NULL;
        if (actionName != null) {
            action = LocalHistory.startAction((Project)project, (String)actionName);
        }
        try {
            List exceptions = helper.runTransactionRunnable((AbstractVcs)vcs, new TransactionRunnable(){

                public void run(List<VcsException> exceptions) {
                    VirtualFile badFile = null;
                    try {
                        if (BasicAction.this.isBatchAction()) {
                            BasicAction.this.batchExecute(project, vcs, files, dataContext, helper);
                        } else {
                            for (int i = 0; files != null && i < files.length; ++i) {
                                VirtualFile file;
                                badFile = file = files[i];
                                BasicAction.this.execute(project, vcs, file, dataContext, helper);
                            }
                        }
                    }
                    catch (VcsException ex) {
                        ex.setVirtualFile(badFile);
                        exceptions.add(ex);
                    }
                }
            }, null);
            helper.showErrors(exceptions, actionName != null ? actionName : vcs.getName());
        }
        finally {
            action.finish();
        }
    }

    public void update(AnActionEvent e) {
        super.update(e);
        Presentation presentation = e.getPresentation();
        DataContext dataContext = e.getDataContext();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            presentation.setEnabled(false);
            presentation.setVisible(false);
            return;
        }
        if (!this.needsFiles()) {
            presentation.setEnabled(true);
            presentation.setVisible(true);
            return;
        }
        VirtualFile[] files = (VirtualFile[])PlatformDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        if (files == null || files.length == 0) {
            presentation.setEnabled(false);
            presentation.setVisible(true);
            return;
        }
        SvnVcs vcs = SvnVcs.getInstance(project);
        if (!ProjectLevelVcsManager.getInstance((Project)project).checkAllFilesAreUnder((AbstractVcs)vcs, files)) {
            presentation.setEnabled(false);
            presentation.setVisible(true);
            return;
        }
        boolean enabled = true;
        if (!this.needsAllFiles()) {
            enabled = false;
        }
        LOG.debug(((Object)((Object)this)).getClass().getName() + (enabled ? " needsAllFiles" : " needsSingleFile"));
        for (int i = 0; i < files.length; ++i) {
            VirtualFile file = files[i];
            boolean fileEnabled = false;
            try {
                fileEnabled = this.isEnabled(project, vcs, file);
            }
            catch (Throwable t) {
                LOG.debug(t);
            }
            LOG.debug("file:" + file.getPath() + (fileEnabled ? " is enabled" : " is not enabled"));
            if (this.needsAllFiles()) {
                if (fileEnabled) continue;
                LOG.debug("now disabled");
                enabled = false;
                break;
            }
            if (!fileEnabled) continue;
            LOG.debug("now enabled");
            enabled = true;
        }
        presentation.setEnabled(enabled);
        presentation.setVisible(true);
    }

    protected boolean needsAllFiles() {
        return this.needsFiles();
    }

    protected void execute(Project project, SvnVcs activeVcs, final VirtualFile file, DataContext context, AbstractVcsHelper helper) throws VcsException {
        if (file.isDirectory()) {
            this.perform(project, activeVcs, file, context);
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    file.refresh(false, true);
                }
            });
            this.doVcsRefresh(project, file);
        } else {
            this.perform(project, activeVcs, file, context);
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    file.refresh(false, true);
                }
            });
            this.doVcsRefresh(project, file);
        }
    }

    protected void doVcsRefresh(Project project, VirtualFile file) {
        VcsDirtyScopeManager.getInstance((Project)project).fileDirty(file);
    }

    private void batchExecute(Project project, SvnVcs activeVcs, final VirtualFile[] file, DataContext context, AbstractVcsHelper helper) throws VcsException {
        this.batchPerform(project, activeVcs, file, context);
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; file != null && i < file.length; ++i) {
                    file[i].refresh(false, true);
                }
            }
        });
        for (int i = 0; file != null && i < file.length; ++i) {
            this.doVcsRefresh(project, file[i]);
        }
    }

    protected abstract String getActionName(AbstractVcs var1);

    protected abstract boolean isEnabled(Project var1, SvnVcs var2, VirtualFile var3);

    protected abstract boolean needsFiles();

    protected abstract void perform(Project var1, SvnVcs var2, VirtualFile var3, DataContext var4) throws VcsException;

    protected abstract void batchPerform(Project var1, SvnVcs var2, VirtualFile[] var3, DataContext var4) throws VcsException;

    protected abstract boolean isBatchAction();
}

